/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;

public class BuildahCommitCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "commit";
    private static final String REM_CONT_AFTER_COMMIT = "--rm";
    private static final String DISABLE_COMPRESSION = "--disable-compression";
    private static final String TLS_VERIFY = "--tls-verify=false";
    private static final String CERT_DIR = "--cert-dir";
    private static final String CREDENTIALS = "--creds";
    private static final String AUTH_FILE = "--authfile";
    private String containerId;
    private String newImageName;
    private Boolean remContAfterCommit = Boolean.FALSE;
    private Boolean disableCompression = Boolean.FALSE;
    private Boolean tlsVerify = Boolean.TRUE;
    private String certDir;
    private String credentials;
    private String authfile;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahCommitCommand(CliExecutor buildahExecutor, String containerId) {
        super(buildahExecutor);
        this.containerId = containerId;
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.authfile != null) {
            arguments.add(AUTH_FILE);
            arguments.add(this.authfile);
        }
        if (this.certDir != null) {
            arguments.add(CERT_DIR);
            arguments.add(this.certDir);
        }
        if (this.tlsVerify != null && this.tlsVerify.booleanValue()) {
            arguments.add(TLS_VERIFY);
        }
        if (this.credentials != null) {
            arguments.add(CREDENTIALS);
            arguments.add(this.credentials);
        }
        if (this.remContAfterCommit != null && this.remContAfterCommit.booleanValue()) {
            arguments.add(REM_CONT_AFTER_COMMIT);
        }
        if (this.disableCompression != null && this.disableCompression.booleanValue()) {
            arguments.add(DISABLE_COMPRESSION);
        }
        arguments.add(this.containerId);
        if (this.newImageName != null) {
            arguments.add(this.newImageName);
        }
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahCommitCommand buildahCommitCommand;

        public Builder(String containerId, CliExecutor buildahExecutor) {
            this.buildahCommitCommand = new BuildahCommitCommand(buildahExecutor, containerId);
        }

        public Builder withImageName(String newImageName) {
            this.buildahCommitCommand.newImageName = newImageName;
            return this;
        }

        public Builder contRemAfterCommit(boolean remContAfterCommit) {
            this.buildahCommitCommand.remContAfterCommit = remContAfterCommit;
            return this;
        }

        public Builder disablecompression(boolean disableCompression) {
            this.buildahCommitCommand.disableCompression = disableCompression;
            return this;
        }

        public Builder tlsVerification(boolean tlsVerify) {
            this.buildahCommitCommand.tlsVerify = tlsVerify;
            return this;
        }

        public Builder authfile(String authfile) {
            this.buildahCommitCommand.authfile = authfile;
            return this;
        }

        public Builder certDir(String certDir) {
            this.buildahCommitCommand.certDir = certDir;
            return this;
        }

        public Builder credentials(String credentials) {
            this.buildahCommitCommand.credentials = credentials;
            return this;
        }

        public BuildahCommitCommand build() {
            this.buildahCommitCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahCommitCommand;
        }
    }
}

