/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core.commands;

import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.commands.AbstractRunnableCommand;
import io.jshift.buildah.core.commands.GlobalParametersSupport;
import java.util.ArrayList;
import java.util.List;

public class BuildahBudCommand
extends AbstractRunnableCommand<Void> {
    private static final String COMMAND_NAME = "bud";
    private static final String FILE = "--file";
    private static final String TARGET_IMAGE = "-t";
    private static final String TLS_VERIFY = "--tls-verify=false";
    private static final String RUNTIME_FLAG = "--runtime-flag";
    private static final String CERT_DIR = "--cert-dir";
    private static final String CREDENTIALS = "--creds";
    private static final String AUTH_FILE = "--authfile";
    private static final String ULIMIT = "-ulimit";
    private static final String MEMORY = "--memory";
    private static final String CPU_PERIOD = "--cpu-period";
    private static final String CPU_QUOTA = "--cpu-quota";
    List<String> dockerfileList;
    private String dockerfileContext;
    private String targetImage;
    private Boolean tlsVerify = Boolean.TRUE;
    private Boolean runtimeFlag = Boolean.FALSE;
    private String certDir;
    private String credentials;
    private String authfile;
    private List<String> ulimitOptionList;
    private String memory;
    private String cpuPeriod;
    private String cpuQuota;
    private GlobalParametersSupport globalParametersSupport;

    protected BuildahBudCommand(CliExecutor buildahExecutor, String dockerfileContext) {
        super(buildahExecutor);
        this.dockerfileContext = dockerfileContext;
    }

    @Override
    public List<String> getCliCommand() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(COMMAND_NAME);
        if (this.authfile != null) {
            arguments.add(AUTH_FILE);
            arguments.add(this.authfile);
        }
        if (this.memory != null) {
            arguments.add(MEMORY);
            arguments.add(this.memory);
        }
        if (this.cpuPeriod != null) {
            arguments.add(CPU_PERIOD);
            arguments.add(this.cpuPeriod);
        }
        if (this.cpuQuota != null) {
            arguments.add(CPU_QUOTA);
            arguments.add(this.cpuQuota);
        }
        if (this.ulimitOptionList != null) {
            for (String option : this.ulimitOptionList) {
                arguments.add(ULIMIT);
                arguments.add(option);
            }
        }
        if (this.certDir != null) {
            arguments.add(CERT_DIR);
            arguments.add(this.certDir);
        }
        if (this.credentials != null) {
            arguments.add(CREDENTIALS);
            arguments.add(this.credentials);
        }
        if (this.runtimeFlag != null && this.runtimeFlag.booleanValue()) {
            arguments.add(RUNTIME_FLAG);
        }
        if (this.tlsVerify != null && this.tlsVerify.booleanValue()) {
            arguments.add(TLS_VERIFY);
        }
        if (this.dockerfileList != null) {
            for (String dockerfile : this.dockerfileList) {
                arguments.add(FILE);
                arguments.add(dockerfile);
            }
        }
        if (this.targetImage != null) {
            arguments.add(TARGET_IMAGE);
            arguments.add(this.targetImage);
        }
        arguments.add(this.dockerfileContext);
        return arguments;
    }

    public static class Builder
    extends GlobalParametersSupport.Builder<Builder> {
        private BuildahBudCommand buildahBudCommand;

        public Builder(CliExecutor buildahExecutor, String context) {
            this.buildahBudCommand = new BuildahBudCommand(buildahExecutor, context);
        }

        public Builder authfile(String authfile) {
            this.buildahBudCommand.authfile = authfile;
            return this;
        }

        public Builder memory(String memory) {
            this.buildahBudCommand.memory = memory;
            return this;
        }

        public Builder cpuPeriod(String cpuPeriod) {
            this.buildahBudCommand.cpuPeriod = cpuPeriod;
            return this;
        }

        public Builder cpuQuota(String cpuQouta) {
            this.buildahBudCommand.cpuQuota = cpuQouta;
            return this;
        }

        public Builder ulimitOptionList(List<String> ulimitOptionList) {
            this.buildahBudCommand.ulimitOptionList = ulimitOptionList;
            return this;
        }

        public Builder certDir(String certDir) {
            this.buildahBudCommand.certDir = certDir;
            return this;
        }

        public Builder credentials(String credentials) {
            this.buildahBudCommand.credentials = credentials;
            return this;
        }

        public Builder runtimeFlag(boolean runtimeFlag) {
            this.buildahBudCommand.runtimeFlag = runtimeFlag;
            return this;
        }

        public Builder tlsVerify(boolean tlsVerify) {
            this.buildahBudCommand.tlsVerify = tlsVerify;
            return this;
        }

        public Builder dockerfileList(List<String> dockerfileList) {
            this.buildahBudCommand.dockerfileList = dockerfileList;
            return this;
        }

        public Builder targetImage(String targetImage) {
            this.buildahBudCommand.targetImage = targetImage;
            return this;
        }

        public BuildahBudCommand build() {
            this.buildahBudCommand.globalParametersSupport = this.buildGlobalParameters();
            return this.buildahBudCommand;
        }
    }
}

