/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FileManager {
    private InputStream content;
    private String name;

    FileManager(String name, InputStream content) {
        this.content = content;
        this.name = name;
    }

    Path copyToLocation(Path location) throws IOException {
        Path output = location.resolve(this.name);
        try (InputStream stream = this.content;){
            Files.copy(stream, output, StandardCopyOption.REPLACE_EXISTING);
        }
        return output;
    }

    Path copyToTemp() throws IOException {
        Path buildahTempDirectory = Files.createTempDirectory("buildah", new FileAttribute[0]);
        return this.copyToLocation(buildahTempDirectory);
    }
}

