/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.buildah.core;

import io.jshift.buildah.api.BuildahConfiguration;
import io.jshift.buildah.api.Command;
import io.jshift.buildah.core.CliExecutor;
import io.jshift.buildah.core.terminal.CaptureOutput;
import io.jshift.buildah.core.terminal.ConsoleOutput;
import io.jshift.buildah.core.terminal.StreamDispatcher;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;

public class BuildahExecutor
implements CliExecutor {
    private static final Logger logger = Logger.getLogger(BuildahExecutor.class.getName());
    private BuildahConfiguration buildahConfiguration;
    private Path buildahHome;
    private Path runcHome;

    BuildahExecutor(Path buildahHome, Path runcHome, BuildahConfiguration buildahConfiguration) {
        this.buildahHome = buildahHome;
        this.runcHome = runcHome;
        this.buildahConfiguration = buildahConfiguration;
    }

    @Override
    public List<String> execute(Command command) {
        return this.execute(this.buildahHome.getParent(), this.runcHome.getParent(), command);
    }

    @Override
    public List<String> execute(Path buildahDirectory, Path runcDirectory, Command command) {
        this.validateInput(this.buildahHome, buildahDirectory, this.runcHome, runcDirectory);
        ArrayList<String> executionCommand = new ArrayList<String>();
        executionCommand.add(this.buildahHome.toString());
        executionCommand.addAll(command.getCliCommand());
        logger.info(String.format("Executing binary: %s at %s", executionCommand.stream().collect(Collectors.joining(" ")), buildahDirectory));
        CaptureOutput captureOutput = new CaptureOutput();
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = captureOutput::capture;
        StreamDispatcher stdStreamDispatcher = new StreamDispatcher(consumerArray);
        if (this.buildahConfiguration.isPrintStandardStreamToConsole()) {
            stdStreamDispatcher.addConsumer(ConsoleOutput.forStandardConsoleOutput()::print);
        }
        StreamDispatcher errStreamDispatcher = new StreamDispatcher(new Consumer[0]);
        if (this.buildahConfiguration.isPrintErrorStreamToConsole()) {
            errStreamDispatcher.addConsumer(ConsoleOutput.forErrorConsoleOutput()::print);
        }
        try {
            new ProcessExecutor().directory(buildahDirectory.toFile()).directory(runcDirectory.toFile()).command(executionCommand).destroyOnExit().exitValueNormal().readOutput(true).redirectOutput((OutputStream)((Object)stdStreamDispatcher)).redirectErrorStream(false).redirectError((OutputStream)((Object)errStreamDispatcher)).execute();
        }
        catch (InvalidExitValueException e) {
            throw new IllegalStateException(String.format("Error code %d. Result: %s", e.getExitValue(), e.getResult().outputUTF8()));
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            throw new IllegalArgumentException(e);
        }
        return captureOutput.getOutput();
    }

    private void validateInput(Path buildahBinary, Path buildahDirectory, Path runcBinary, Path runcDirectory) {
        if (!Files.isRegularFile(buildahBinary, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s binary path should point to buildah executable.", buildahBinary));
        }
        if (!Files.isRegularFile(runcBinary, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s binary path should point to runc executable.", runcBinary));
        }
        if (!Files.isDirectory(buildahDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s should be a directory where running buildah (typically the cloned project)", buildahDirectory));
        }
        if (!Files.isDirectory(runcDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s should be a directory where running runc (typically the cloned project)", runcDirectory));
        }
    }
}

