/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client.sse;

import io.joshworks.stream.client.sse.UTF8Output;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public class EventStreamChannelListener
implements ChannelListener<StreamSourceChannel> {
    private static final Logger logger = LoggerFactory.getLogger(EventStreamChannelListener.class);
    private final UTF8Output string;
    private final ByteBufferPool bufferPool;

    public EventStreamChannelListener(ByteBufferPool bufferPool, UTF8Output utf8Output) {
        this.bufferPool = bufferPool;
        this.string = utf8Output;
    }

    public void handleEvent(StreamSourceChannel channel) {
        this.process(channel);
    }

    public void setup(StreamSourceChannel channel) {
        this.process(channel);
        channel.getReadSetter().set((ChannelListener)this);
        channel.resumeReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(StreamSourceChannel channel) {
        PooledByteBuffer resource = this.bufferPool.allocate();
        ByteBuffer buffer = resource.getBuffer();
        try {
            int read;
            do {
                if ((read = channel.read(buffer)) == 0) {
                    return;
                }
                if (read == -1) {
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                this.string.write(buffer);
            } while (read > 0);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            resource.close();
        }
    }
}

