/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client;

import io.joshworks.stream.client.ConnectionMonitor;
import io.joshworks.stream.client.sse.SSEConnection;
import io.joshworks.stream.client.sse.SseClientCallback;
import io.joshworks.stream.client.sse.SseConfiguration;
import io.joshworks.stream.client.ws.WebSocketClientEndpoint;
import io.joshworks.stream.client.ws.WsConfiguration;
import io.joshworks.stream.client.ws.WsConnection;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public final class StreamClient {
    private static final ConnectionMonitor monitor = new ConnectionMonitor();
    private static final Logger logger = LoggerFactory.getLogger(StreamClient.class);
    private static final String CLIENT_WORKER_NAME = "client-worker";
    private static OptionMap options = OptionMap.builder().set(Options.WORKER_IO_THREADS, 5).set(Options.TCP_NODELAY, true).set(Options.WORKER_NAME, (Object)"client-worker").set(Options.KEEP_ALIVE, true).getMap();
    private static StreamClient INSTANCE;
    private final ScheduledExecutorService scheduler;
    private final XnioWorker worker;

    private StreamClient(XnioWorker worker, ScheduledExecutorService scheduler) {
        this.worker = worker;
        this.scheduler = scheduler;
    }

    public static void configure(OptionMap options) {
        if (INSTANCE != null) {
            logger.warn("StreamClient already in use, configuration will have no effect");
            return;
        }
        StreamClient.options = options;
    }

    public static synchronized void shutdown() {
        monitor.closeAll();
        if (INSTANCE != null) {
            logger.info("Shutting down StreamClient workers");
            StreamClient.INSTANCE.worker.shutdownNow();
            StreamClient.INSTANCE.scheduler.shutdownNow();
            INSTANCE = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StreamClient instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<StreamClient> clazz = StreamClient.class;
        synchronized (StreamClient.class) {
            if (INSTANCE != null) return INSTANCE;
            XnioWorker workers = StreamClient.createWorkers();
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
            INSTANCE = new StreamClient(workers, scheduler);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static XnioWorker createWorkers() {
        try {
            return Xnio.getInstance().createWorker(options);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static WsConfiguration ws(String url) {
        StreamClient instance = StreamClient.instance();
        return new WsConfiguration(url, instance.worker, instance.scheduler, monitor);
    }

    public static WsConnection connect(String url, WebSocketClientEndpoint endpoint) {
        StreamClient instance = StreamClient.instance();
        return new WsConfiguration(url, instance.worker, instance.scheduler, monitor, endpoint).connect();
    }

    public static SseConfiguration sse(String url) {
        StreamClient instance = StreamClient.instance();
        return new SseConfiguration(url, instance.worker, instance.scheduler, monitor);
    }

    public static SSEConnection connect(String url, SseClientCallback clientCallback) {
        StreamClient instance = StreamClient.instance();
        return new SseConfiguration(url, instance.worker, instance.scheduler, monitor, clientCallback).connect();
    }
}

