/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client.ws;

import io.joshworks.stream.client.ClientConfiguration;
import io.joshworks.stream.client.StreamConnection;
import io.joshworks.stream.client.ws.ProxyClientEndpoint;
import io.joshworks.stream.client.ws.WebSocketClientEndpoint;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;

public class WsConnection
extends StreamConnection {
    private static final Logger logger = LoggerFactory.getLogger(WsConnection.class);
    private final WebSocketClientEndpoint endpoint;
    private boolean clientClose = false;
    private WebSocketChannel webSocketChannel;

    WsConnection(ClientConfiguration configuration, WebSocketClientEndpoint endpoint) {
        super(configuration);
        this.endpoint = endpoint;
    }

    @Override
    protected synchronized void tryConnect() throws Exception {
        if (this.webSocketChannel != null) {
            return;
        }
        this.shuttingDown = false;
        this.webSocketChannel = (WebSocketChannel)new WebSocketClient.ConnectionBuilder(this.worker, (ByteBufferPool)new DefaultByteBufferPool(false, 2048), URI.create(this.url)).connect().get();
        ProxyClientEndpoint proxyClientEndpoint = new ProxyClientEndpoint(this.endpoint);
        this.webSocketChannel.getReceiveSetter().set((ChannelListener)proxyClientEndpoint);
        this.webSocketChannel.getCloseSetter().set(channel -> {
            if (!this.clientClose) {
                this.closeChannel();
                proxyClientEndpoint.onCloseMessage(null, this.webSocketChannel);
                this.reconnect();
            }
        });
        proxyClientEndpoint.onConnect(this.webSocketChannel);
        this.webSocketChannel.resumeReceives();
        this.monitor.add(this.uuid, this::closeChannel);
        this.clientClose = false;
    }

    public boolean isOpen() {
        return this.webSocketChannel != null && this.webSocketChannel.isOpen();
    }

    public void close() {
        this.close(new CloseMessage(1000, "Client disconnected"));
    }

    public void close(CloseMessage closeMessage) {
        this.sendClose(closeMessage);
        this.closeChannel();
    }

    @Override
    protected synchronized void closeChannel() {
        if (this.webSocketChannel != null) {
            StreamConnection.closeChannel((Channel)this.webSocketChannel);
            this.clientClose = true;
            this.webSocketChannel = null;
            this.monitor.remove(this.uuid);
        }
    }

    private void sendClose(CloseMessage closeMessage) {
        try {
            if (this.isOpen()) {
                this.webSocketChannel.setCloseCode(closeMessage.getCode());
                this.webSocketChannel.setCloseReason(closeMessage.getReason());
                this.webSocketChannel.sendClose();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while sending shutdown message", e);
        }
    }

    public WebSocketChannel channel() {
        return this.webSocketChannel;
    }

    public CompletableFuture<WsConnection> sendText(String message) {
        this.checkChannelClosed();
        final CompletableFuture<WsConnection> future = new CompletableFuture<WsConnection>();
        WebSockets.sendText((String)message, (WebSocketChannel)this.webSocketChannel, (WebSocketCallback)new WebSocketCallback<WsConnection>(){

            public void complete(WebSocketChannel channel, WsConnection context) {
                future.complete(context);
            }

            public void onError(WebSocketChannel channel, WsConnection context, Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, (Object)this);
        return future;
    }

    public CompletableFuture<WsConnection> sendBinary(byte[] bytes) {
        return this.sendBinary(ByteBuffer.wrap(bytes));
    }

    public CompletableFuture<WsConnection> sendBinary(ByteBuffer byteBuffer) {
        this.checkChannelClosed();
        final CompletableFuture<WsConnection> future = new CompletableFuture<WsConnection>();
        WebSockets.sendBinary((ByteBuffer)byteBuffer, (WebSocketChannel)this.webSocketChannel, (WebSocketCallback)new WebSocketCallback<WsConnection>(){

            public void complete(WebSocketChannel channel, WsConnection context) {
                future.complete(context);
            }

            public void onError(WebSocketChannel channel, WsConnection context, Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, (Object)this);
        return future;
    }

    public CompletableFuture<WsConnection> sendPing(byte[] bytes) {
        return this.sendPing(ByteBuffer.wrap(bytes));
    }

    public CompletableFuture<WsConnection> sendPing(ByteBuffer byteBuffer) {
        this.checkChannelClosed();
        final CompletableFuture<WsConnection> future = new CompletableFuture<WsConnection>();
        WebSockets.sendPing((ByteBuffer)byteBuffer, (WebSocketChannel)this.webSocketChannel, (WebSocketCallback)new WebSocketCallback<WsConnection>(){

            public void complete(WebSocketChannel channel, WsConnection context) {
                future.complete(context);
            }

            public void onError(WebSocketChannel channel, WsConnection context, Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, (Object)this);
        return future;
    }

    public CompletableFuture<WsConnection> sendPong(byte[] bytes) {
        return this.sendPong(ByteBuffer.wrap(bytes));
    }

    public CompletableFuture<WsConnection> sendPong(ByteBuffer byteBuffer) {
        this.checkChannelClosed();
        final CompletableFuture<WsConnection> future = new CompletableFuture<WsConnection>();
        WebSockets.sendPong((ByteBuffer)byteBuffer, (WebSocketChannel)this.webSocketChannel, (WebSocketCallback)new WebSocketCallback<WsConnection>(){

            public void complete(WebSocketChannel channel, WsConnection context) {
                future.complete(context);
            }

            public void onError(WebSocketChannel channel, WsConnection context, Throwable throwable) {
                future.completeExceptionally(throwable);
            }
        }, (Object)this);
        return future;
    }

    private void checkChannelClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Channel is not open");
        }
    }
}

