/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client.ws;

import io.joshworks.stream.client.ClientConfiguration;
import io.joshworks.stream.client.ConnectionMonitor;
import io.joshworks.stream.client.ws.WebSocketClientEndpoint;
import io.joshworks.stream.client.ws.WsConnection;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.xnio.XnioWorker;

public class WsConfiguration
extends ClientConfiguration {
    private Consumer<WebSocketChannel> onConnect;
    private BiConsumer<WebSocketChannel, BufferedBinaryMessage> onPing;
    private BiConsumer<WebSocketChannel, BufferedBinaryMessage> onPong;
    private BiConsumer<WebSocketChannel, BufferedTextMessage> onText;
    private BiConsumer<WebSocketChannel, BufferedBinaryMessage> onBinary;
    private BiConsumer<WebSocketChannel, Exception> onError;
    private BiConsumer<WebSocketChannel, CloseMessage> onClose;
    private WebSocketClientEndpoint endpoint;

    public WsConfiguration(String url, XnioWorker worker, ScheduledExecutorService scheduler, ConnectionMonitor monitor) {
        super(url, worker, scheduler, monitor);
        this.onConnect = channel -> {};
        this.onPing = (wsChannel, channel) -> {};
        this.onPong = (wsChannel, channel) -> {};
        this.onText = (wsChannel, channel) -> {};
        this.onBinary = (wsChannel, channel) -> {};
        this.onError = (wsChannel, error) -> {};
        this.onClose = (wsChannel, message) -> {};
    }

    public WsConfiguration(String url, XnioWorker worker, ScheduledExecutorService scheduler, ConnectionMonitor monitor, WebSocketClientEndpoint endpoint) {
        super(url, worker, scheduler, monitor);
        this.onConnect = channel -> {};
        this.onPing = (wsChannel, channel) -> {};
        this.onPong = (wsChannel, channel) -> {};
        this.onText = (wsChannel, channel) -> {};
        this.onBinary = (wsChannel, channel) -> {};
        this.onError = (wsChannel, error) -> {};
        this.onClose = (wsChannel, message) -> {};
        this.endpoint = endpoint;
    }

    public WsConfiguration onConnect(Consumer<WebSocketChannel> onConnect) {
        this.onConnect = onConnect;
        return this;
    }

    public WsConfiguration onClose(BiConsumer<WebSocketChannel, CloseMessage> onClose) {
        this.onClose = onClose;
        return this;
    }

    public WsConfiguration onPing(BiConsumer<WebSocketChannel, BufferedBinaryMessage> onPing) {
        this.onPing = onPing;
        return this;
    }

    public WsConfiguration onPong(BiConsumer<WebSocketChannel, BufferedBinaryMessage> onPong) {
        this.onPong = onPong;
        return this;
    }

    public WsConfiguration onText(BiConsumer<WebSocketChannel, BufferedTextMessage> onText) {
        this.onText = onText;
        return this;
    }

    public WsConfiguration onBinary(BiConsumer<WebSocketChannel, BufferedBinaryMessage> onBinary) {
        this.onBinary = onBinary;
        return this;
    }

    public WsConfiguration onError(BiConsumer<WebSocketChannel, Exception> onError) {
        this.onError = onError;
        return this;
    }

    public WsConfiguration onFailedAttempt(Runnable onFailedAttempt) {
        this.onFailedAttempt = onFailedAttempt;
        return this;
    }

    public WsConfiguration onRetriesExceeded(Runnable onRetriesExceeded) {
        this.onRetriesExceeded = onRetriesExceeded;
        return this;
    }

    public WsConfiguration retryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public WsConfiguration maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public WsConfiguration clientEndpoint(WebSocketClientEndpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public WsConnection connectAsync() {
        this.endpoint = this.endpoint == null ? this.createEndpoint() : this.endpoint;
        WsConnection wsConnection = new WsConnection(this, this.endpoint);
        wsConnection.connect();
        return wsConnection;
    }

    public WsConnection connect() {
        this.endpoint = this.endpoint == null ? this.createEndpoint() : this.endpoint;
        WsConnection wsConnection = new WsConnection(this, this.endpoint);
        try {
            wsConnection.tryConnect();
        }
        catch (Exception e) {
            if (this.maxRetries == 0) {
                throw new RuntimeException("Could not connect to " + this.url, e);
            }
            wsConnection.connect();
        }
        return wsConnection;
    }

    private WebSocketClientEndpoint createEndpoint() {
        return new WebSocketClientEndpoint(){

            @Override
            protected void onConnect(WebSocketChannel channel) {
                WsConfiguration.this.onConnect.accept(channel);
            }

            @Override
            protected void onClose(WebSocketChannel channel, CloseMessage message) {
                WsConfiguration.this.onClose.accept(channel, message);
            }

            @Override
            protected void onPing(WebSocketChannel channel, BufferedBinaryMessage message) {
                WsConfiguration.this.onPing.accept(channel, message);
            }

            @Override
            protected void onPong(WebSocketChannel channel, BufferedBinaryMessage message) {
                WsConfiguration.this.onPong.accept(channel, message);
            }

            @Override
            protected void onText(WebSocketChannel channel, BufferedTextMessage message) {
                WsConfiguration.this.onText.accept(channel, message);
            }

            @Override
            protected void onBinary(WebSocketChannel channel, BufferedBinaryMessage message) {
                WsConfiguration.this.onBinary.accept(channel, message);
            }

            @Override
            protected void onError(WebSocketChannel channel, Exception error) {
                WsConfiguration.this.onError.accept(channel, error);
            }
        };
    }
}

