/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client;

import io.joshworks.stream.client.ClientConfiguration;
import io.joshworks.stream.client.ConnectionMonitor;
import io.joshworks.stream.client.MaxRetryExceeded;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.XnioWorker;

public abstract class StreamConnection {
    private static final Logger logger = LoggerFactory.getLogger(StreamConnection.class);
    protected final String url;
    protected final XnioWorker worker;
    protected final String uuid = UUID.randomUUID().toString().substring(0, 8);
    protected final ConnectionMonitor monitor;
    private final ScheduledExecutorService scheduler;
    private final long retryInterval;
    private final int maxRetries;
    private final Runnable onFailedAttempt;
    private final Runnable onRetriesExceeded;
    protected boolean shuttingDown = false;
    private int retries = 0;

    public StreamConnection(ClientConfiguration clientConfiguration) {
        this.url = clientConfiguration.url;
        this.scheduler = clientConfiguration.scheduler;
        this.monitor = clientConfiguration.monitor;
        this.retryInterval = clientConfiguration.retryInterval;
        this.maxRetries = clientConfiguration.maxRetries;
        this.worker = clientConfiguration.worker;
        this.onFailedAttempt = clientConfiguration.onFailedAttempt;
        this.onRetriesExceeded = clientConfiguration.onRetriesExceeded;
    }

    protected abstract void tryConnect() throws Exception;

    protected abstract void closeChannel();

    public void connect() {
        this.retries = 0;
        this.shuttingDown = false;
        this.tryConnect(0L);
    }

    protected static void closeChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            logger.error("Error while closing channel", (Throwable)e);
        }
    }

    protected void reconnect() {
        this.reconnect(this.retryInterval);
    }

    protected void reconnect(long delay) {
        if (this.shuttingDown || this.maxRetries == 0) {
            return;
        }
        if (++this.retries > this.maxRetries && this.maxRetries > 0) {
            this.onRetriesExceeded.run();
            MaxRetryExceeded maxRetryExceeded = new MaxRetryExceeded("Max retries (" + this.maxRetries + ") exceeded, not reconnecting");
            logger.error("Max retries exceeded", (Throwable)maxRetryExceeded);
            this.closeChannel();
            return;
        }
        this.tryConnect(delay);
    }

    private void tryConnect(long delay) {
        String maxRetriesLabel = this.maxRetries < 0 ? "-" : "" + this.maxRetries;
        logger.info("Trying to connect to {} in {}ms. {} of {}", new Object[]{this.url, this.retryInterval, this.retries, maxRetriesLabel});
        try {
            if (this.scheduler.isTerminated() || this.scheduler.isShutdown()) {
                logger.warn("Scheduler service shutdown, not reconnecting");
                return;
            }
            this.scheduler.schedule(() -> {
                try {
                    this.tryConnect();
                    this.retries = 0;
                    logger.info("Connected to {}", (Object)this.url);
                }
                catch (Exception e) {
                    logger.warn("Could not connect to {}: {}", (Object)this.url, (Object)e.getMessage());
                    this.onFailedAttempt.run();
                    this.closeChannel();
                    this.reconnect();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("Error while scheduling reconnection", (Throwable)e);
        }
    }
}

