/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client.ws;

import io.joshworks.stream.client.ClientConfiguration;
import io.joshworks.stream.client.StreamConnection;
import io.joshworks.stream.client.ws.ProxyClientEndpoint;
import io.joshworks.stream.client.ws.WebSocketClientEndpoint;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.ChannelListener;

public class WsConnection
extends StreamConnection {
    private static final Logger logger = LoggerFactory.getLogger(WsConnection.class);
    private final WebSocketClientEndpoint endpoint;
    private boolean clientClose = false;
    private WebSocketChannel webSocketChannel;

    WsConnection(ClientConfiguration configuration, WebSocketClientEndpoint endpoint) {
        super(configuration);
        this.endpoint = endpoint;
    }

    @Override
    protected synchronized void tryConnect() throws IOException {
        try {
            if (this.webSocketChannel != null) {
                return;
            }
            this.shuttingDown = false;
            logger.info("Connecting to {}", (Object)this.url);
            this.webSocketChannel = (WebSocketChannel)new WebSocketClient.ConnectionBuilder(this.worker, (ByteBufferPool)new DefaultByteBufferPool(false, 2048), URI.create(this.url)).connect().get();
            ProxyClientEndpoint proxyClientEndpoint = new ProxyClientEndpoint(this.endpoint);
            this.webSocketChannel.getReceiveSetter().set((ChannelListener)proxyClientEndpoint);
            this.webSocketChannel.getCloseSetter().set(channel -> {
                if (!this.clientClose) {
                    this.closeChannel();
                    proxyClientEndpoint.onCloseMessage(null, this.webSocketChannel);
                    this.reconnect();
                }
            });
            proxyClientEndpoint.onConnect(this.webSocketChannel);
            this.webSocketChannel.resumeReceives();
            this.monitor.add(this.uuid, this::closeChannel);
            logger.info("Connected to {}", (Object)this.url);
            this.clientClose = false;
        }
        catch (Exception e) {
            logger.warn("Could not tryConnect to " + this.url, (Throwable)e);
            throw e;
        }
    }

    public boolean isOpen() {
        return this.webSocketChannel != null && this.webSocketChannel.isOpen();
    }

    public void close() {
        this.close(new CloseMessage(1000, "Client disconnected"));
    }

    public void close(CloseMessage closeMessage) {
        this.sendClose(closeMessage);
        this.closeChannel();
    }

    @Override
    protected synchronized void closeChannel() {
        if (this.webSocketChannel != null) {
            StreamConnection.closeChannel((Channel)this.webSocketChannel);
            this.clientClose = true;
            this.webSocketChannel = null;
            this.monitor.remove(this.uuid);
        }
    }

    private void sendClose(CloseMessage closeMessage) {
        try {
            if (this.webSocketChannel != null && this.webSocketChannel.isOpen()) {
                this.webSocketChannel.setCloseCode(closeMessage.getCode());
                this.webSocketChannel.setCloseReason(closeMessage.getReason());
                this.webSocketChannel.sendClose();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while sending shutdown message", e);
        }
    }

    public WebSocketChannel channel() {
        return this.webSocketChannel;
    }

    public void sendText(String message) {
        WebSockets.sendText((String)message, (WebSocketChannel)this.webSocketChannel, null);
    }

    public void sendBinary(ByteBuffer byteBuffer) {
        WebSockets.sendBinary((ByteBuffer)byteBuffer, (WebSocketChannel)this.webSocketChannel, null);
    }

    public void sendBinary(byte[] bytes) {
        WebSockets.sendBinary((ByteBuffer)ByteBuffer.wrap(bytes), (WebSocketChannel)this.webSocketChannel, null);
    }
}

