/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client.sse;

import io.joshworks.stream.client.ClientConfiguration;
import io.joshworks.stream.client.ConnectionMonitor;
import io.joshworks.stream.client.sse.EventData;
import io.joshworks.stream.client.sse.SSEConnection;
import io.joshworks.stream.client.sse.SseClientCallback;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.xnio.XnioWorker;

public class SseConfiguration
extends ClientConfiguration {
    private SseClientCallback clientCallback;
    private String lastEventId;
    private Runnable onOpen;
    private Consumer<EventData> onEvent;
    private Consumer<String> onClose;
    private Consumer<Exception> onError;

    public SseConfiguration(String url, XnioWorker worker, ScheduledExecutorService scheduler, ConnectionMonitor register) {
        super(url, worker, scheduler, register);
        this.onOpen = () -> {};
        this.onEvent = eventData -> {};
        this.onClose = lastEventId -> {};
        this.onError = e -> {};
    }

    public SseConfiguration(String url, XnioWorker worker, ScheduledExecutorService scheduler, ConnectionMonitor register, SseClientCallback clientCallback) {
        super(url, worker, scheduler, register);
        this.onOpen = () -> {};
        this.onEvent = eventData -> {};
        this.onClose = lastEventId -> {};
        this.onError = e -> {};
        this.clientCallback = clientCallback;
    }

    public SseConfiguration onOpen(Runnable onOpen) {
        this.onOpen = onOpen;
        return this;
    }

    public SseConfiguration onEvent(Consumer<EventData> onEvent) {
        this.onEvent = onEvent;
        return this;
    }

    public SseConfiguration onClose(Consumer<String> onClose) {
        this.onClose = onClose;
        return this;
    }

    public SseConfiguration onFailedAttempt(Runnable onFailedAttempt) {
        this.onFailedAttempt = onFailedAttempt;
        return this;
    }

    public SseConfiguration onRetriesExceeded(Runnable onRetriesExceeded) {
        this.onRetriesExceeded = onRetriesExceeded;
        return this;
    }

    public SseConfiguration onError(Consumer<Exception> onError) {
        this.onError = onError;
        return this;
    }

    public SseConfiguration lastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
        return this;
    }

    public SseConfiguration maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public SseConfiguration retryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public SseConfiguration autoReconnect(boolean reconnect) {
        this.autoReconnect = reconnect;
        return this;
    }

    public SseConfiguration clientCallback(SseClientCallback callback) {
        this.clientCallback = callback;
        return this;
    }

    public SSEConnection connect() {
        this.clientCallback = this.clientCallback == null ? this.createClientCallback() : this.clientCallback;
        SSEConnection connection = new SSEConnection(this, this.lastEventId, this.clientCallback);
        connection.connect();
        return connection;
    }

    private SseClientCallback createClientCallback() {
        return new SseClientCallback(){

            @Override
            public void onEvent(EventData event) {
                SseConfiguration.this.onEvent.accept(event);
            }

            @Override
            public void onOpen() {
                SseConfiguration.this.onOpen.run();
            }

            @Override
            public void onClose(String lastEventId) {
                SseConfiguration.this.onClose.accept(lastEventId);
            }

            @Override
            public void onError(Exception e) {
                SseConfiguration.this.onError.accept(e);
            }
        };
    }
}

