/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client.sse;

import io.joshworks.stream.client.sse.EventData;
import io.joshworks.stream.client.sse.SSEConnection;
import java.util.regex.Pattern;

public class EventStreamParser {
    private static final String DATA = "data";
    private static final String ID = "id";
    private static final String EVENT = "event";
    private static final String RETRY = "autoReconnect";
    private static final String DEFAULT_EVENT = "message";
    private static final String LINE_BREAK = "\n";
    private static final String EMPTY_STRING = "";
    private static final String WHITESPACE = " ";
    private static final String COLON = ":";
    private static final Pattern NUMERIC = Pattern.compile("^[\\d]+$");
    private StringBuffer data = new StringBuffer();
    private String lastEventId;
    private String eventName = "message";
    private String origin = "";
    private final SSEConnection connection;

    EventStreamParser(SSEConnection connection) {
        this.connection = connection;
    }

    public void lines(String lines) {
        String[] lineArray;
        for (String line : lineArray = lines.split(LINE_BREAK, -1)) {
            this.parse(line);
        }
    }

    public void parse(String line) {
        if (line.trim().isEmpty()) {
            this.dispatchEvent();
        } else if (!line.startsWith(COLON)) {
            int colonIndex = line.indexOf(COLON);
            if (colonIndex != -1) {
                String field = line.substring(0, colonIndex);
                String value = line.substring(colonIndex + 1).replaceFirst(WHITESPACE, EMPTY_STRING);
                this.processField(field, value);
            } else {
                this.processField(line.trim(), EMPTY_STRING);
            }
        }
    }

    private void processField(String field, String value) {
        if (DATA.equals(field)) {
            this.data.append(value);
        } else if (ID.equals(field)) {
            this.lastEventId = value;
        } else if (EVENT.equals(field)) {
            this.eventName = value;
        } else if (RETRY.equals(field) && this.isNumber(value)) {
            this.connection.retryAfter(Long.parseLong(value));
        }
    }

    private boolean isNumber(String value) {
        return NUMERIC.matcher(value).matches();
    }

    private void dispatchEvent() {
        if (this.data.length() == 0) {
            return;
        }
        EventData message = new EventData(this.removeLineBreak(this.data.toString()), this.removeLineBreak(this.lastEventId), this.removeLineBreak(this.eventName), this.removeLineBreak(this.origin));
        this.connection.lastEventId = this.removeLineBreak(this.lastEventId);
        try {
            this.connection.callback.onEvent(message);
        }
        catch (Exception e) {
            this.connection.callback.onError(e);
        }
        this.data = new StringBuffer();
        this.eventName = DEFAULT_EVENT;
    }

    private String removeLineBreak(String value) {
        if (value == null) {
            return null;
        }
        if (value.endsWith(LINE_BREAK)) {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }
}

