/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client;

import io.joshworks.stream.client.ClientConfiguration;
import io.joshworks.stream.client.ConnectionMonitor;
import io.joshworks.stream.client.MaxRetryExceeded;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.XnioWorker;

public abstract class StreamConnection {
    private static final Logger logger = LoggerFactory.getLogger(StreamConnection.class);
    protected final String url;
    protected final XnioWorker worker;
    protected final String uuid = UUID.randomUUID().toString().substring(0, 8);
    protected final ConnectionMonitor monitor;
    private final ScheduledExecutorService scheduler;
    private final long reconnectInterval;
    private final int maxRetries;
    private final boolean autoReconnect;
    private final Runnable onFailedAttempt;
    private final Runnable onRetriesExceeded;
    protected boolean shuttingDown = false;
    private int retries = 0;

    public StreamConnection(ClientConfiguration clientConfiguration) {
        this.url = clientConfiguration.url;
        this.scheduler = clientConfiguration.scheduler;
        this.monitor = clientConfiguration.monitor;
        this.reconnectInterval = clientConfiguration.retryInterval;
        this.maxRetries = clientConfiguration.maxRetries;
        this.autoReconnect = clientConfiguration.autoReconnect;
        this.worker = clientConfiguration.worker;
        this.onFailedAttempt = clientConfiguration.onFailedAttempt;
        this.onRetriesExceeded = clientConfiguration.onRetriesExceeded;
    }

    protected abstract void tryConnect() throws Exception;

    protected abstract void closeChannel();

    public void connect() {
        this.shuttingDown = false;
        this.tryConnect(false, 0L);
    }

    protected static void closeChannel(Channel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                logger.error("Error while closing channel", (Throwable)e);
            }
        }
    }

    protected void retry() {
        if (this.maxRetries == 0) {
            this.onRetriesExceeded.run();
        }
        this.tryConnect(false, this.reconnectInterval);
    }

    protected void reconnect() {
        if (this.autoReconnect) {
            logger.info("Connection closed. Not reconnecting");
        }
        this.tryConnect(true, this.reconnectInterval);
    }

    protected void tryConnect(boolean isReconnection, long delay) {
        if (this.retries++ > this.maxRetries && this.maxRetries >= 0) {
            this.onRetriesExceeded.run();
            throw new MaxRetryExceeded("Max retries (" + this.maxRetries + ") exceeded, not reconnecting");
        }
        if (this.shuttingDown || isReconnection && !this.autoReconnect) {
            return;
        }
        logger.info("Trying to connect to {} in {}ms, autoReconnect {} of {}", new Object[]{this.url, this.reconnectInterval, this.retries, this.maxRetries});
        try {
            if (this.scheduler.isTerminated() || this.scheduler.isShutdown()) {
                logger.warn("Scheduler service shutdown, not reconnecting");
                return;
            }
            this.scheduler.schedule(() -> {
                try {
                    this.tryConnect();
                }
                catch (Exception e) {
                    this.onFailedAttempt.run();
                    this.closeChannel();
                    this.retry();
                }
                this.retries = 0;
            }, delay, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("Error while scheduling reconnection", (Throwable)e);
        }
    }
}

