/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.stream.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionMonitor.class);
    private static final Map<String, Runnable> connections = new ConcurrentHashMap<String, Runnable>();

    public void add(String uuid, Runnable close) {
        connections.put(uuid, close);
    }

    public void remove(String uuid) {
        connections.remove(uuid);
    }

    void closeAll() {
        for (Map.Entry<String, Runnable> entry : connections.entrySet()) {
            try {
                logger.info("Shutting down client connection with uuid: {}", (Object)entry.getKey());
                entry.getValue().run();
            }
            catch (Exception exception) {}
        }
    }
}

