/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.maven.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class JavaExecutable {
    private File file;

    public JavaExecutable() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || javaHome.isEmpty()) {
            throw new IllegalStateException("Unable to find java executable due to missing 'java.home'");
        }
        this.file = this.findInJavaHome(javaHome);
    }

    private File findInJavaHome(String javaHome) {
        File bin = new File(new File(javaHome), "bin");
        File command = new File(bin, "java.exe");
        File file = command = command.exists() ? command : new File(bin, "java");
        if (command.exists()) {
            throw new IllegalStateException("Unable to find java in " + javaHome);
        }
        return command;
    }

    public ProcessBuilder processBuilder(String ... arguments) {
        ProcessBuilder processBuilder = new ProcessBuilder(this.toString());
        processBuilder.command().addAll(Arrays.asList(arguments));
        return processBuilder;
    }

    public String toString() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

