/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.maven;

import io.joshworks.snappy.maven.AbstractDependencyFilterMojo;
import io.joshworks.snappy.maven.ArtifactsLibraries;
import io.joshworks.snappy.maven.Exclude;
import io.joshworks.snappy.maven.ExcludeFilter;
import io.joshworks.snappy.maven.tools.DefaultLaunchScript;
import io.joshworks.snappy.maven.tools.LaunchScript;
import io.joshworks.snappy.maven.tools.Layout;
import io.joshworks.snappy.maven.tools.Layouts;
import io.joshworks.snappy.maven.tools.Repackager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

@Mojo(name="repackage", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class RepackageMojo
extends AbstractDependencyFilterMojo {
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String classifier;
    @Parameter
    private String mainClass;
    @Parameter
    private LayoutType layout;
    @Parameter
    private List<Dependency> requiresUnpack;
    @Parameter(defaultValue="false")
    private boolean executable;
    @Parameter
    private File embeddedLaunchScript;
    @Parameter
    private Properties embeddedLaunchScriptProperties;
    @Parameter(defaultValue="false")
    private boolean excludeDevtools;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"repackage goal could not be applied to pom project.");
            return;
        }
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping repackaging as per configuration.");
            return;
        }
        File source = this.project.getArtifact().getFile();
        File target = this.getTargetFile();
        Repackager repackager = new Repackager(source){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected String findMainMethod(JarFile source) throws IOException {
                long startTime = System.currentTimeMillis();
                try {
                    String string = super.findMainMethod(source);
                    return string;
                }
                finally {
                    long duration = System.currentTimeMillis() - startTime;
                    if (duration > FIND_WARNING_TIMEOUT) {
                        RepackageMojo.this.getLog().warn((CharSequence)"Searching for the main-class is taking some time, consider using the mainClass configuration parameter");
                    }
                }
            }
        };
        repackager.setMainClass(this.mainClass);
        if (this.layout != null) {
            this.getLog().info((CharSequence)("Layout: " + this.layout));
            repackager.setLayout(this.layout.layout());
        }
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), this.getFilters(this.getAdditionalFilters()));
        ArtifactsLibraries libraries = new ArtifactsLibraries(artifacts, this.requiresUnpack, this.getLog());
        try {
            LaunchScript launchScript = this.getLaunchScript();
            repackager.repackage(target, libraries, launchScript);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        if (this.classifier != null) {
            this.getLog().info((CharSequence)("Attaching archive: " + target + ", with classifier: " + this.classifier));
            this.projectHelper.attachArtifact(this.project, this.project.getPackaging(), this.classifier, target);
        } else if (!source.equals(target)) {
            this.project.getArtifact().setFile(target);
            this.getLog().info((CharSequence)("Replacing main artifact " + source + " to " + target));
        }
    }

    private ArtifactsFilter[] getAdditionalFilters() {
        if (this.excludeDevtools) {
            Exclude exclude = new Exclude();
            exclude.setGroupId("org.springframework.boot");
            exclude.setArtifactId("spring-boot-devtools");
            ExcludeFilter filter = new ExcludeFilter(exclude);
            return new ArtifactsFilter[]{filter};
        }
        return new ArtifactsFilter[0];
    }

    private File getTargetFile() {
        Object classifier;
        Object object = classifier = this.classifier == null ? "" : this.classifier.trim();
        if (((String)classifier).length() > 0 && !((String)classifier).startsWith("-")) {
            classifier = "-" + (String)classifier;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + (String)classifier + "." + this.project.getArtifact().getArtifactHandler().getExtension());
    }

    private LaunchScript getLaunchScript() throws IOException {
        if (this.executable || this.embeddedLaunchScript != null) {
            return new DefaultLaunchScript(this.embeddedLaunchScript, this.buildLaunchScriptProperties());
        }
        return null;
    }

    private Properties buildLaunchScriptProperties() {
        Properties properties = new Properties();
        if (this.embeddedLaunchScriptProperties != null) {
            properties.putAll((Map<?, ?>)this.embeddedLaunchScriptProperties);
        }
        this.putIfMissing(properties, "initInfoProvides", this.project.getArtifactId());
        this.putIfMissing(properties, "initInfoShortDescription", this.project.getName(), this.project.getArtifactId());
        this.putIfMissing(properties, "initInfoDescription", this.removeLineBreaks(this.project.getDescription()), this.project.getName(), this.project.getArtifactId());
        return properties;
    }

    private String removeLineBreaks(String description) {
        return description == null ? null : description.replaceAll("\\s+", " ");
    }

    private void putIfMissing(Properties properties, String key, String ... valueCandidates) {
        if (!properties.containsKey(key)) {
            for (String candidate : valueCandidates) {
                if (candidate == null || candidate.length() <= 0) continue;
                properties.put(key, candidate);
                return;
            }
        }
    }

    public static enum LayoutType {
        JAR(new Layouts.Jar()),
        WAR(new Layouts.War()),
        ZIP(new Layouts.Expanded()),
        DIR(new Layouts.Expanded()),
        MODULE(new Layouts.Module()),
        NONE(new Layouts.None());

        private final Layout layout;

        private LayoutType(Layout layout) {
            this.layout = layout;
        }

        public Layout layout() {
            return this.layout;
        }
    }
}

