/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.maven;

import io.joshworks.snappy.maven.tools.Libraries;
import io.joshworks.snappy.maven.tools.Library;
import io.joshworks.snappy.maven.tools.LibraryCallback;
import io.joshworks.snappy.maven.tools.LibraryScope;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;

public class ArtifactsLibraries
implements Libraries {
    private static final Map<String, LibraryScope> SCOPES;
    private final Set<Artifact> artifacts;
    private final Collection<Dependency> unpacks;
    private final Log log;

    public ArtifactsLibraries(Set<Artifact> artifacts, Collection<Dependency> unpacks, Log log) {
        this.artifacts = artifacts;
        this.unpacks = unpacks;
        this.log = log;
    }

    @Override
    public void doWithLibraries(LibraryCallback callback) throws IOException {
        Set<String> duplicates = this.getDuplicates(this.artifacts);
        for (Artifact artifact : this.artifacts) {
            LibraryScope scope = SCOPES.get(artifact.getScope());
            if (scope == null || artifact.getFile() == null) continue;
            Object name = artifact.getFile().getName();
            if (duplicates.contains(name)) {
                this.log.debug((CharSequence)("Duplicate found: " + (String)name));
                name = artifact.getGroupId() + "-" + (String)name;
                this.log.debug((CharSequence)("Renamed to: " + (String)name));
            }
            callback.library(new Library((String)name, artifact.getFile(), scope, this.isUnpackRequired(artifact)));
        }
    }

    private Set<String> getDuplicates(Set<Artifact> artifacts) {
        HashSet<String> duplicates = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || seen.add(artifact.getFile().getName())) continue;
            duplicates.add(artifact.getFile().getName());
        }
        return duplicates;
    }

    private boolean isUnpackRequired(Artifact artifact) {
        if (this.unpacks != null) {
            for (Dependency unpack : this.unpacks) {
                if (!artifact.getGroupId().equals(unpack.getGroupId()) || !artifact.getArtifactId().equals(unpack.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashMap<String, LibraryScope> scopes = new HashMap<String, LibraryScope>();
        scopes.put("compile", LibraryScope.COMPILE);
        scopes.put("runtime", LibraryScope.RUNTIME);
        scopes.put("provided", LibraryScope.PROVIDED);
        SCOPES = Collections.unmodifiableMap(scopes);
    }
}

