/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.loader.jar;

import io.joshworks.snappy.loader.data.RandomAccessData;
import io.joshworks.snappy.loader.data.RandomAccessDataFile;
import io.joshworks.snappy.loader.jar.CentralDirectoryEndRecord;
import io.joshworks.snappy.loader.jar.Handler;
import io.joshworks.snappy.loader.jar.JarEntry;
import io.joshworks.snappy.loader.jar.JarEntryData;
import io.joshworks.snappy.loader.jar.JarEntryFilter;
import io.joshworks.snappy.loader.util.AsciiBytes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class JarFile
extends java.util.jar.JarFile
implements Iterable<JarEntryData> {
    private static final AsciiBytes META_INF = new AsciiBytes("META-INF/");
    private static final AsciiBytes MANIFEST_MF = new AsciiBytes("META-INF/MANIFEST.MF");
    private static final AsciiBytes SIGNATURE_FILE_EXTENSION = new AsciiBytes(".SF");
    private static final String PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    private static final String HANDLERS_PACKAGE = "io.joshworks.boot.loader";
    private static final AsciiBytes SLASH = new AsciiBytes("/");
    private final RandomAccessDataFile rootFile;
    private final String pathFromRoot;
    private final RandomAccessData data;
    private final List<JarEntryData> entries;
    private SoftReference<Map<AsciiBytes, JarEntryData>> entriesByName;
    private boolean signed;
    private JarEntryData manifestEntry;
    private SoftReference<Manifest> manifest;
    private URL url;

    public JarFile(File file) throws IOException {
        this(new RandomAccessDataFile(file));
    }

    JarFile(RandomAccessDataFile file) throws IOException {
        this(file, "", file);
    }

    private JarFile(RandomAccessDataFile rootFile, String pathFromRoot, RandomAccessData data) throws IOException {
        super(rootFile.getFile());
        CentralDirectoryEndRecord endRecord = new CentralDirectoryEndRecord(data);
        this.rootFile = rootFile;
        this.pathFromRoot = pathFromRoot;
        this.data = this.getArchiveData(endRecord, data);
        this.entries = this.loadJarEntries(endRecord);
    }

    private JarFile(RandomAccessDataFile rootFile, String pathFromRoot, RandomAccessData data, List<JarEntryData> entries, JarEntryFilter ... filters) throws IOException {
        super(rootFile.getFile());
        this.rootFile = rootFile;
        this.pathFromRoot = pathFromRoot;
        this.data = data;
        this.entries = this.filterEntries(entries, filters);
    }

    public static void registerUrlProtocolHandler() {
        String handlers = System.getProperty(PROTOCOL_HANDLER, "");
        System.setProperty(PROTOCOL_HANDLER, (String)("".equals(handlers) ? HANDLERS_PACKAGE : handlers + "|io.joshworks.boot.loader"));
        JarFile.resetCachedUrlHandlers();
    }

    private static void resetCachedUrlHandlers() {
        try {
            URL.setURLStreamHandlerFactory(null);
        }
        catch (Error error) {
            // empty catch block
        }
    }

    private RandomAccessData getArchiveData(CentralDirectoryEndRecord endRecord, RandomAccessData data) {
        long offset = endRecord.getStartOfArchive(data);
        if (offset == 0L) {
            return data;
        }
        return data.getSubsection(offset, data.getSize() - offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JarEntryData> loadJarEntries(CentralDirectoryEndRecord endRecord) throws IOException {
        RandomAccessData centralDirectory = endRecord.getCentralDirectory(this.data);
        int numberOfRecords = endRecord.getNumberOfRecords();
        ArrayList<JarEntryData> entries = new ArrayList<JarEntryData>(numberOfRecords);
        try (InputStream inputStream = centralDirectory.getInputStream(RandomAccessData.ResourceAccess.ONCE);){
            JarEntryData entry = JarEntryData.fromInputStream(this, inputStream);
            while (entry != null) {
                entries.add(entry);
                this.processEntry(entry);
                entry = JarEntryData.fromInputStream(this, inputStream);
            }
        }
        return entries;
    }

    private List<JarEntryData> filterEntries(List<JarEntryData> entries, JarEntryFilter[] filters) {
        ArrayList<JarEntryData> filteredEntries = new ArrayList<JarEntryData>(entries.size());
        for (JarEntryData entry : entries) {
            AsciiBytes name = entry.getName();
            for (JarEntryFilter filter : filters) {
                name = filter == null || name == null ? name : filter.apply(name, entry);
            }
            if (name == null) continue;
            JarEntryData filteredCopy = entry.createFilteredCopy(this, name);
            filteredEntries.add(filteredCopy);
            this.processEntry(filteredCopy);
        }
        return filteredEntries;
    }

    private void processEntry(JarEntryData entry) {
        AsciiBytes name = entry.getName();
        if (name.startsWith(META_INF)) {
            this.processMetaInfEntry(name, entry);
        }
    }

    private void processMetaInfEntry(AsciiBytes name, JarEntryData entry) {
        if (name.equals(MANIFEST_MF)) {
            this.manifestEntry = entry;
        }
        if (name.endsWith(SIGNATURE_FILE_EXTENSION)) {
            this.signed = true;
        }
    }

    protected final RandomAccessDataFile getRootJarFile() {
        return this.rootFile;
    }

    RandomAccessData getData() {
        return this.data;
    }

    @Override
    public Manifest getManifest() throws IOException {
        Manifest manifest;
        if (this.manifestEntry == null) {
            return null;
        }
        Manifest manifest2 = manifest = this.manifest == null ? null : this.manifest.get();
        if (manifest == null) {
            try (InputStream inputStream = this.manifestEntry.getInputStream();){
                manifest = new Manifest(inputStream);
            }
            this.manifest = new SoftReference<Manifest>(manifest);
        }
        return manifest;
    }

    @Override
    public Enumeration<java.util.jar.JarEntry> entries() {
        final Iterator<JarEntryData> iterator = this.iterator();
        return new Enumeration<java.util.jar.JarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public java.util.jar.JarEntry nextElement() {
                return ((JarEntryData)iterator.next()).asJarEntry();
            }
        };
    }

    @Override
    public Iterator<JarEntryData> iterator() {
        return this.entries.iterator();
    }

    @Override
    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    @Override
    public ZipEntry getEntry(String name) {
        JarEntryData jarEntryData = this.getJarEntryData(name);
        return jarEntryData == null ? null : jarEntryData.asJarEntry();
    }

    public JarEntryData getJarEntryData(String name) {
        if (name == null) {
            return null;
        }
        return this.getJarEntryData(new AsciiBytes(name));
    }

    public JarEntryData getJarEntryData(AsciiBytes name) {
        JarEntryData entryData;
        Map<AsciiBytes, JarEntryData> entriesByName;
        if (name == null) {
            return null;
        }
        Map<AsciiBytes, JarEntryData> map = entriesByName = this.entriesByName == null ? null : this.entriesByName.get();
        if (entriesByName == null) {
            entriesByName = new HashMap<AsciiBytes, JarEntryData>();
            for (JarEntryData entry : this.entries) {
                entriesByName.put(entry.getName(), entry);
            }
            this.entriesByName = new SoftReference<Map<AsciiBytes, JarEntryData>>(entriesByName);
        }
        if ((entryData = entriesByName.get(name)) == null && !name.endsWith(SLASH)) {
            entryData = entriesByName.get(name.append(SLASH));
        }
        return entryData;
    }

    boolean isSigned() {
        return this.signed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupEntryCertificates() {
        try (JarInputStream inputStream = new JarInputStream(this.getData().getInputStream(RandomAccessData.ResourceAccess.ONCE));){
            java.util.jar.JarEntry entry = inputStream.getNextJarEntry();
            while (entry != null) {
                inputStream.closeEntry();
                JarEntry jarEntry = this.getJarEntry(entry.getName());
                if (jarEntry != null) {
                    jarEntry.setupCertificates(entry);
                }
                entry = inputStream.getNextJarEntry();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry ze) throws IOException {
        return this.getContainedEntry(ze).getSource().getInputStream();
    }

    public synchronized JarFile getNestedJarFile(ZipEntry entry) throws IOException {
        return this.getNestedJarFile(this.getContainedEntry(entry).getSource());
    }

    public synchronized JarFile getNestedJarFile(JarEntryData sourceEntry) throws IOException {
        try {
            if (sourceEntry.nestedJar == null) {
                sourceEntry.nestedJar = this.createJarFileFromEntry(sourceEntry);
            }
            return sourceEntry.nestedJar;
        }
        catch (IOException ex) {
            throw new IOException("Unable to open nested jar file '" + sourceEntry.getName() + "'", ex);
        }
    }

    private JarFile createJarFileFromEntry(JarEntryData sourceEntry) throws IOException {
        if (sourceEntry.isDirectory()) {
            return this.createJarFileFromDirectoryEntry(sourceEntry);
        }
        return this.createJarFileFromFileEntry(sourceEntry);
    }

    private JarFile createJarFileFromDirectoryEntry(JarEntryData sourceEntry) throws IOException {
        final AsciiBytes sourceName = sourceEntry.getName();
        JarEntryFilter filter = new JarEntryFilter(){

            @Override
            public AsciiBytes apply(AsciiBytes name, JarEntryData entryData) {
                if (name.startsWith(sourceName) && !name.equals(sourceName)) {
                    return name.substring(sourceName.length());
                }
                return null;
            }
        };
        return new JarFile(this.rootFile, this.pathFromRoot + "!/" + sourceEntry.getName().substring(0, sourceName.length() - 1), this.data, this.entries, filter);
    }

    private JarFile createJarFileFromFileEntry(JarEntryData sourceEntry) throws IOException {
        if (sourceEntry.getMethod() != 0) {
            throw new IllegalStateException("Unable to open nested entry '" + sourceEntry.getName() + "'. It has been compressed and nested jar files must be stored without compression. Please check the mechanism used to create your executable jar file");
        }
        return new JarFile(this.rootFile, this.pathFromRoot + "!/" + sourceEntry.getName(), sourceEntry.getData());
    }

    public synchronized JarFile getFilteredJarFile(JarEntryFilter ... filters) throws IOException {
        return new JarFile(this.rootFile, this.pathFromRoot, this.data, this.entries, filters);
    }

    private JarEntry getContainedEntry(ZipEntry zipEntry) throws IOException {
        if (zipEntry instanceof JarEntry && ((JarEntry)zipEntry).getSource().getSource() == this) {
            return (JarEntry)zipEntry;
        }
        throw new IllegalArgumentException("ZipEntry must be contained in this file");
    }

    @Override
    public int size() {
        return (int)this.data.getSize();
    }

    @Override
    public void close() throws IOException {
        this.rootFile.close();
    }

    public URL getUrl() throws MalformedURLException {
        if (this.url == null) {
            Handler handler = new Handler(this);
            Object file = this.rootFile.getFile().toURI() + this.pathFromRoot + "!/";
            file = ((String)file).replace("file:////", "file://");
            this.url = new URL("jar", "", -1, (String)file, handler);
        }
        return this.url;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        String path = this.pathFromRoot;
        return this.rootFile.getFile() + path;
    }
}

