/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard.stats;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PoolStats {
    private final int activeCount;
    private final long completedTaskCount;
    private final int corePoolSize;
    private final int largestPoolSize;
    private final int maximumPoolSize;
    private final int poolSize;
    private final String rejectionPolicy;
    private final long taskCount;
    private final int queueCapacity;
    private final int queuedTasks;
    private final String poolName;
    private final long keepAliveTime;
    private final boolean shutdown;

    public PoolStats(String poolName, ThreadPoolExecutor executor) {
        this.poolName = poolName;
        this.activeCount = executor.getActiveCount();
        this.completedTaskCount = executor.getCompletedTaskCount();
        this.corePoolSize = executor.getCorePoolSize();
        this.largestPoolSize = executor.getLargestPoolSize();
        this.maximumPoolSize = executor.getMaximumPoolSize();
        this.poolSize = executor.getPoolSize();
        this.rejectionPolicy = executor.getRejectedExecutionHandler().getClass().getSimpleName();
        this.taskCount = executor.getTaskCount();
        this.queuedTasks = executor.getQueue().size();
        this.queueCapacity = executor.getQueue().remainingCapacity() + executor.getQueue().size();
        this.keepAliveTime = executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
        this.shutdown = executor.isShutdown();
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public long getTaskCount() {
        return this.taskCount;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getQueuedTasks() {
        return this.queuedTasks;
    }

    public String getRejectionPolicy() {
        return this.rejectionPolicy;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

