/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard.resource;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class RestMetricsHandler
implements HttpHandler {
    protected final HttpHandler next;
    private volatile MetricResult totalResult = new MetricResult(new Date());
    private boolean enabled = true;

    public RestMetricsHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.enabled) {
            long start = System.currentTimeMillis();
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                long time = System.currentTimeMillis() - start;
                this.totalResult.update((int)time, String.valueOf(exchange1.getStatusCode()));
                nextListener.proceed();
            });
        }
        this.next.handleRequest(exchange);
    }

    public void reset() {
        this.totalResult = new MetricResult(new Date());
    }

    MetricResult getMetrics() {
        return this.enabled ? new MetricResult(this.totalResult) : new MetricResult();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static class MetricResult {
        private static final AtomicLongFieldUpdater<MetricResult> totalRequestTimeUpdater = AtomicLongFieldUpdater.newUpdater(MetricResult.class, "totalRequestTime");
        private static final AtomicIntegerFieldUpdater<MetricResult> maxRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(MetricResult.class, "maxRequestTime");
        private static final AtomicIntegerFieldUpdater<MetricResult> minRequestTimeUpdater = AtomicIntegerFieldUpdater.newUpdater(MetricResult.class, "minRequestTime");
        private static final AtomicLongFieldUpdater<MetricResult> invocationsUpdater = AtomicLongFieldUpdater.newUpdater(MetricResult.class, "totalRequests");
        private Date metricsStartDate;
        private volatile long totalRequestTime;
        private volatile int maxRequestTime;
        private volatile int minRequestTime = -1;
        private volatile long totalRequests;
        private ConcurrentHashMap<String, AtomicLong> responses = new ConcurrentHashMap();

        MetricResult(Date metricsStartDate) {
            this.metricsStartDate = metricsStartDate;
        }

        MetricResult() {
        }

        MetricResult(MetricResult copy) {
            this.metricsStartDate = copy.metricsStartDate;
            this.totalRequestTime = copy.totalRequestTime;
            this.maxRequestTime = copy.maxRequestTime;
            this.minRequestTime = copy.minRequestTime;
            this.totalRequests = copy.totalRequests;
            for (Map.Entry<String, AtomicLong> entry : copy.responses.entrySet()) {
                this.responses.put(entry.getKey(), new AtomicLong(entry.getValue().longValue()));
            }
        }

        void update(int requestTime, String code) {
            int minRequestTime;
            int maxRequestTime;
            totalRequestTimeUpdater.addAndGet(this, requestTime);
            while (requestTime >= (maxRequestTime = this.maxRequestTime) && !maxRequestTimeUpdater.compareAndSet(this, maxRequestTime, requestTime)) {
            }
            while (!(requestTime > (minRequestTime = this.minRequestTime) && minRequestTime != -1 || minRequestTimeUpdater.compareAndSet(this, minRequestTime, requestTime))) {
            }
            invocationsUpdater.incrementAndGet(this);
            this.responses.putIfAbsent(code, new AtomicLong(0L));
            this.responses.get(code).incrementAndGet();
        }
    }
}

