/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard.resource;

import io.joshworks.snappy.extensions.dashboard.resource.ResourceMetricHolder;
import io.joshworks.snappy.http.Request;
import io.joshworks.snappy.http.Response;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ResourcesMetricResource {
    private final ResourceMetricHolder resourceMetricHolder;

    public ResourcesMetricResource(ResourceMetricHolder registeredMetricHandlers) {
        this.resourceMetricHolder = registeredMetricHandlers;
    }

    public Response getMetrics(Request exchange) {
        return Response.withBody(this.resourceMetricHolder.getMetrics());
    }

    public Response getMetric(Request exchange) {
        String id = exchange.pathParameter("id");
        List foundById = this.resourceMetricHolder.getMetrics().stream().filter(rm -> id.equals(rm.id)).collect(Collectors.toList());
        return foundById.isEmpty() ? Response.notFound() : Response.withBody(foundById.get(0));
    }

    public Response updateMetric(Request exchange) {
        Object enabled = exchange.body().asMap().get("enabled");
        if (enabled != null) {
            boolean metricsEnabled = Boolean.parseBoolean(String.valueOf(enabled));
            this.resourceMetricHolder.setMetricsEnabled(metricsEnabled);
        }
        return Response.noContent();
    }

    public Response metricStatus(Request exchange) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        response.put("enabled", this.resourceMetricHolder.isMetricsEnabled());
        return Response.withBody(response);
    }
}

