/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard.resource;

import io.joshworks.snappy.extensions.dashboard.resource.RestMetric;
import io.joshworks.snappy.extensions.dashboard.resource.RestMetricsHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ResourceMetricHolder {
    private boolean metricsEnabled = true;
    private final List<ResourceMetricItem> registeredEndpoints = new ArrayList<ResourceMetricItem>();
    private final List<RestMetricsHandler> metricsHandlers = new ArrayList<RestMetricsHandler>();

    public void add(String method, String url, RestMetricsHandler handler) {
        this.metricsHandlers.add(handler);
        handler.setEnabled(this.metricsEnabled);
        this.registeredEndpoints.add(new ResourceMetricItem(method, url, handler::getMetrics));
    }

    public List<RestMetric> getMetrics() {
        return this.registeredEndpoints.stream().map(re -> new RestMetric(re.id, ((ResourceMetricItem)re).url, ((ResourceMetricItem)re).method, (RestMetricsHandler.MetricResult)((ResourceMetricItem)re).metricsSupplier.get())).collect(Collectors.toList());
    }

    public void setMetricsEnabled(boolean enabled) {
        this.metricsHandlers.forEach(rmh -> rmh.setEnabled(enabled));
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public static class ResourceMetricItem {
        public final String id = UUID.randomUUID().toString().substring(0, 8);
        private final String method;
        private final String url;
        private final Supplier<RestMetricsHandler.MetricResult> metricsSupplier;

        public ResourceMetricItem(String method, String url, Supplier<RestMetricsHandler.MetricResult> metricsSupplier) {
            this.method = method;
            this.url = url;
            this.metricsSupplier = metricsSupplier;
        }
    }
}

