/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard.metrics;

import io.joshworks.snappy.extensions.dashboard.AdminExtension;
import io.joshworks.snappy.extensions.dashboard.TimeMetric;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Metrics {
    private static final Map<String, TimeMetric<Number>> numberSuppliers = new ConcurrentHashMap<String, TimeMetric<Number>>();
    private static final Map<String, TimeMetric<Boolean>> booleanSuppliers = new ConcurrentHashMap<String, TimeMetric<Boolean>>();
    private static final long UPDATE_FREQUENCY = Duration.ofMinutes(1L).toMillis();
    private static boolean started = false;
    private static boolean enabled = true;

    private Metrics() {
    }

    public static void supplyNumber(String key, long frequency, Supplier<Number> supplier) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        numberSuppliers.put(key, new TimeMetric<Number>(key, frequency, supplier));
        Metrics.tryStartMetricsUpdater();
    }

    public static void supplyBoolean(String key, long frequency, Supplier<Boolean> supplier) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        booleanSuppliers.put(key, new TimeMetric<Boolean>(key, frequency, supplier));
        Metrics.tryStartMetricsUpdater();
    }

    public static synchronized void setEnabled(boolean enabled) {
        Metrics.enabled = enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private static synchronized void tryStartMetricsUpdater() {
        if (!started) {
            AdminExtension.scheduler.scheduleAtFixedRate(() -> {
                if (enabled) {
                    ArrayList<TimeMetric<Serializable>> suppliers = new ArrayList<TimeMetric<Serializable>>();
                    suppliers.addAll(numberSuppliers.values());
                    suppliers.addAll(booleanSuppliers.values());
                    suppliers.forEach(TimeMetric::update);
                }
            }, UPDATE_FREQUENCY, UPDATE_FREQUENCY, TimeUnit.MILLISECONDS);
            started = true;
        }
    }

    static Map<String, Object> getData() {
        HashMap<String, TimeMetric<Serializable>> data = new HashMap<String, TimeMetric<Serializable>>();
        data.putAll(numberSuppliers);
        data.putAll(booleanSuppliers);
        return data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TimeMetric)e.getValue()).getData()));
    }

    static Queue<TimeMetric.Serie> getData(String key) {
        TimeMetric<Number> numberMetric = numberSuppliers.get(key);
        if (numberMetric != null) {
            return numberMetric.getData();
        }
        TimeMetric<Boolean> booleanSupplier = booleanSuppliers.get(key);
        return booleanSupplier == null ? new LinkedList() : booleanSupplier.getData();
    }
}

