/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard.log;

import io.joshworks.snappy.sse.SseBroadcaster;
import java.io.File;
import org.apache.commons.io.input.TailerListenerAdapter;

public class LogTailer
extends TailerListenerAdapter {
    private static final String LOG_EXTENSION = ".log";
    private static final long MAX_FILE_SIZE = 10L;
    final File file;
    private SseBroadcaster broadcaster;

    public LogTailer(String filePath, boolean tailf, SseBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
        this.file = this.getFile(filePath, tailf);
    }

    private File getFile(String fileName, boolean tailf) {
        if (fileName == null || fileName.isEmpty()) {
            throw new RuntimeException("Log location not configured, use '" + this.file.getPath() + "'");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("File '" + fileName + "' doesn't exist");
        }
        if (file.isDirectory() || !file.getName().endsWith(LOG_EXTENSION)) {
            throw new RuntimeException("Not a valid '.log' file, name: '" + fileName + "'");
        }
        if (!tailf && file.length() > 0xA00000L) {
            throw new RuntimeException("File is too big, max allowed is 10mb");
        }
        return file;
    }

    public void handle(String line) {
        this.broadcaster.broadcast(line);
    }
}

