/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard.log;

import io.joshworks.snappy.extensions.dashboard.log.LogTailer;
import io.joshworks.snappy.sse.SseBroadcaster;
import io.joshworks.snappy.sse.SseContext;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStreamer {
    private static final Logger logger = LoggerFactory.getLogger(LogStreamer.class);
    private static final String TAILF_PARAM = "tailf";
    private final Map<SseContext, Tailer> tailers = new HashMap<SseContext, Tailer>();
    private final ExecutorService executor;
    private final String logLocation;
    private final SseBroadcaster broadcaster;

    public LogStreamer(ExecutorService executor, String logLocation, SseBroadcaster broadcaster) {
        this.executor = executor;
        this.logLocation = logLocation;
        this.broadcaster = broadcaster;
    }

    public void handle(SseContext sse) {
        sse.onClose(this::stopStreaming);
        try {
            boolean tailf = sse.queryParameterVal(TAILF_PARAM).asBoolean().orElse(false);
            LogTailer listener = new LogTailer(this.logLocation, tailf, this.broadcaster);
            Tailer tailer = new Tailer(listener.file, (TailerListener)listener, 500L, tailf);
            this.tailers.put(sse, tailer);
            this.executor.execute((Runnable)tailer);
        }
        catch (Exception e) {
            logger.error("Error opening log file", (Throwable)e);
            sse.send(e.getMessage(), new ServerSentEventConnection.EventCallback(){

                public void done(ServerSentEventConnection connection, String data, String event, String id) {
                    try {
                        connection.close();
                    }
                    catch (IOException e1) {
                        logger.error("Error opening log file", (Throwable)e);
                    }
                }

                public void failed(ServerSentEventConnection connection, String data, String event, String id, IOException e2) {
                }
            });
        }
    }

    private void stopTailer(SseContext ctx) {
        Tailer removed = this.tailers.remove(ctx);
        if (removed != null) {
            removed.stop();
        }
    }

    public void stopStreaming() {
        this.tailers.forEach((key, value) -> {
            try {
                this.stopTailer((SseContext)key);
            }
            catch (Exception e) {
                logger.warn("Failed to stop file tailer");
            }
            key.close();
        });
    }
}

