/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard;

import io.joshworks.snappy.extensions.dashboard.RingBuffer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeMetric<T> {
    private static final Logger logger = LoggerFactory.getLogger(TimeMetric.class);
    private static final int HISTORY_SIZE = 100;
    private final long frequency;
    private long lastRun = 0L;
    private final String name;
    private final Supplier<T> supplier;
    private final RingBuffer<Serie> data = RingBuffer.ofSize(100);

    public TimeMetric(String name, long frequency, Supplier<T> supplier) {
        this.name = name;
        this.supplier = supplier;
        this.frequency = frequency;
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (now - this.lastRun >= this.frequency) {
            try {
                T value = this.supplier.get();
                this.data.add(new Serie(now, value));
            }
            catch (Exception e) {
                logger.warn("Could not get metrics for {}: {}", (Object)this.name, (Object)e.getMessage());
            }
        }
    }

    public RingBuffer<Serie> getData() {
        return this.data;
    }

    public static class Serie {
        public final long timestamp;
        public final Object data;

        public Serie(long timestamp, Object data) {
            this.timestamp = timestamp;
            this.data = data;
        }
    }
}

