/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RingBuffer<T>
extends ConcurrentLinkedQueue<T> {
    private int pos = 0;
    private final int size;

    private RingBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be greater than greater than zero");
        }
        this.size = size;
    }

    public static <T> RingBuffer<T> ofSize(int size) {
        return new RingBuffer<T>(size);
    }

    private void checkPosInsert() {
        if (this.pos++ >= this.size) {
            this.poll();
            this.pos = this.size;
        }
    }

    private void checkPosRemove() {
        if (this.pos > 0) {
            --this.pos;
        }
    }

    @Override
    public boolean offer(T t) {
        this.checkPosInsert();
        return super.offer(t);
    }

    @Override
    public T poll() {
        Object poll = super.poll();
        this.checkPosRemove();
        return (T)poll;
    }

    @Override
    public T peek() {
        Object peek = super.peek();
        this.checkPosRemove();
        return (T)peek;
    }

    @Override
    public void clear() {
        this.pos = 0;
        super.clear();
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = super.remove(o);
        this.checkPosRemove();
        return remove;
    }

    @Override
    public T remove() {
        Object remove = super.remove();
        this.checkPosRemove();
        return (T)remove;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported");
    }
}

