/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.extensions.dashboard;

import io.joshworks.snappy.ext.ServerData;
import io.joshworks.snappy.ext.SnappyExtension;
import io.joshworks.snappy.extensions.dashboard.log.LogStreamer;
import io.joshworks.snappy.extensions.dashboard.metrics.AppMetricsResource;
import io.joshworks.snappy.extensions.dashboard.resource.ResourceMetricHolder;
import io.joshworks.snappy.extensions.dashboard.resource.ResourcesMetricResource;
import io.joshworks.snappy.extensions.dashboard.resource.RestMetricsHandler;
import io.joshworks.snappy.extensions.dashboard.stats.ServerStats;
import io.joshworks.snappy.handler.HandlerUtil;
import io.joshworks.snappy.handler.MappedEndpoint;
import io.joshworks.snappy.http.ExceptionMapper;
import io.joshworks.snappy.http.MediaType;
import io.joshworks.snappy.http.Response;
import io.joshworks.snappy.parser.MediaTypes;
import io.joshworks.snappy.property.AppProperties;
import io.joshworks.snappy.sse.SseBroadcaster;
import io.undertow.server.HttpHandler;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminExtension
implements SnappyExtension {
    private static final Logger logger = LoggerFactory.getLogger(AdminExtension.class);
    private static final String EXTENSION_NAME = "DASHBOARD";
    private static final String PREFIX = "dashboard.";
    private static final String PASSWORD = "dashboard.password";
    private static final String LOG_LOCATION = "dashboard.logFile";
    private static final String ADMIN_ROOT_FOLDER = "admin";
    private static final String DEFAULT_PATH = "/";
    private final String path;
    private static final String LOG_SSE = "/logs";
    private static final String METRICS_ENDPOINT = "/metrics";
    private static final String METRICS_STATUS_ENDPOINT = "/metrics/status";
    private static final String METRIC_ENDPOINT = "/metrics/{id}";
    private static final String RESOURCES_METRIC_ENDPOINT = "/resources";
    private static final String RESOURCES_METRIC_STATUS_ENDPOINT = "/resources/status";
    private static final String RESOURCE_METRIC_ENDPOINT = "/resources/{id}";
    private static final String STATS_ENDPOINT = "/stats";
    private static final ExecutorService executor = Executors.newFixedThreadPool(3);
    public static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private LogStreamer streamer;

    public AdminExtension() {
        this(DEFAULT_PATH);
    }

    public AdminExtension(String path) {
        this.path = path;
    }

    public void onStart(ServerData config) {
        config.adminManager.setAdminPage(this.path, ADMIN_ROOT_FOLDER, new ArrayList());
        this.registerStatsEndpoint(config);
        this.registerResourceMetricEndpoints(config);
        this.registerAppMetricsEndpoint(config);
        String logLocation = AppProperties.get((String)LOG_LOCATION).orElse(null);
        SseBroadcaster broadcaster = new SseBroadcaster();
        if (logLocation == null || logLocation.isEmpty()) {
            logger.warn("dashboard.logFile not specified, log won't be available");
        } else {
            this.streamer = new LogStreamer(executor, logLocation, broadcaster);
        }
        config.adminManager.addEndpoint(HandlerUtil.sse((String)LOG_SSE, this.streamer::handle, (SseBroadcaster)broadcaster));
    }

    public void onShutdown() {
        if (this.streamer != null) {
            this.streamer.stopStreaming();
        }
        executor.shutdownNow();
        scheduler.shutdownNow();
    }

    public String name() {
        return EXTENSION_NAME;
    }

    private void registerResourceMetricEndpoints(ServerData config) {
        ResourceMetricHolder resourceMetricHolder = this.wrapHandlerWithMetricsHandler(config);
        ResourcesMetricResource endpoint = new ResourcesMetricResource(resourceMetricHolder);
        MappedEndpoint getMetrics = HandlerUtil.rest((HttpString)Methods.GET, (String)RESOURCES_METRIC_ENDPOINT, (long)config.maxMultipartSize, endpoint::getMetrics, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        MappedEndpoint getMetric = HandlerUtil.rest((HttpString)Methods.GET, (String)RESOURCE_METRIC_ENDPOINT, (long)config.maxMultipartSize, endpoint::getMetric, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        MappedEndpoint updateMetric = HandlerUtil.rest((HttpString)Methods.PUT, (String)RESOURCES_METRIC_STATUS_ENDPOINT, (long)config.maxMultipartSize, endpoint::updateMetric, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        MappedEndpoint metricStatus = HandlerUtil.rest((HttpString)Methods.GET, (String)RESOURCES_METRIC_STATUS_ENDPOINT, (long)config.maxMultipartSize, endpoint::metricStatus, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        config.adminManager.addEndpoint(getMetrics);
        config.adminManager.addEndpoint(getMetric);
        config.adminManager.addEndpoint(updateMetric);
        config.adminManager.addEndpoint(metricStatus);
    }

    private ResourceMetricHolder wrapHandlerWithMetricsHandler(ServerData config) {
        Map<Boolean, List<MappedEndpoint>> splitResources = config.mappedEndpoints.stream().collect(Collectors.partitioningBy(me -> MappedEndpoint.Type.REST.equals((Object)me.type)));
        ResourceMetricHolder resourceMetricHolder = new ResourceMetricHolder();
        List restResources = ((List)splitResources.getOrDefault(true, new ArrayList())).stream().map(me -> {
            RestMetricsHandler restMetricsHandler = new RestMetricsHandler(me.handler);
            resourceMetricHolder.add(me.method, me.url, restMetricsHandler);
            return new MappedEndpoint(me.method, me.url, me.type, (HttpHandler)restMetricsHandler);
        }).collect(Collectors.toList());
        ArrayList replacedResources = new ArrayList();
        replacedResources.addAll(splitResources.getOrDefault(false, new ArrayList()));
        replacedResources.addAll(restResources);
        config.mappedEndpoints.clear();
        config.mappedEndpoints.addAll(replacedResources);
        return resourceMetricHolder;
    }

    private void registerStatsEndpoint(ServerData config) {
        MappedEndpoint getMetrics = HandlerUtil.rest((HttpString)Methods.GET, (String)STATS_ENDPOINT, (long)config.maxMultipartSize, exchange -> Response.withBody((Object)new ServerStats()).type(MediaType.APPLICATION_JSON_TYPE), (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        config.adminManager.addEndpoint(getMetrics);
    }

    private void registerAppMetricsEndpoint(ServerData config) {
        AppMetricsResource appMetricsResource = new AppMetricsResource();
        MappedEndpoint getMetrics = HandlerUtil.rest((HttpString)Methods.GET, (String)METRICS_ENDPOINT, (long)config.maxMultipartSize, appMetricsResource::getMetrics, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        MappedEndpoint getMetric = HandlerUtil.rest((HttpString)Methods.GET, (String)METRIC_ENDPOINT, (long)config.maxMultipartSize, appMetricsResource::getMetric, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        MappedEndpoint updateMetrics = HandlerUtil.rest((HttpString)Methods.PUT, (String)METRICS_STATUS_ENDPOINT, (long)config.maxMultipartSize, appMetricsResource::updateMetricState, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        MappedEndpoint metricsStatus = HandlerUtil.rest((HttpString)Methods.GET, (String)METRICS_STATUS_ENDPOINT, (long)config.maxMultipartSize, appMetricsResource::updateMetricState, (ExceptionMapper)new ExceptionMapper(), (MediaTypes[])new MediaTypes[0]);
        config.adminManager.addEndpoint(getMetrics);
        config.adminManager.addEndpoint(getMetric);
        config.adminManager.addEndpoint(updateMetrics);
        config.adminManager.addEndpoint(metricsStatus);
    }
}

