/*
 * Decompiled with CFR 0.152.
 */
package io.joshworks.snappy.loader;

import io.joshworks.snappy.loader.InputArgumentsJavaAgentDetector;
import io.joshworks.snappy.loader.JavaAgentDetector;
import io.joshworks.snappy.loader.Launcher;
import io.joshworks.snappy.loader.archive.Archive;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class ExecutableArchiveLauncher
extends Launcher {
    private final Archive archive;
    private final JavaAgentDetector javaAgentDetector;

    public ExecutableArchiveLauncher() {
        this(new InputArgumentsJavaAgentDetector());
    }

    public ExecutableArchiveLauncher(JavaAgentDetector javaAgentDetector) {
        try {
            this.archive = this.createArchive();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        this.javaAgentDetector = javaAgentDetector;
    }

    protected ExecutableArchiveLauncher(Archive archive) {
        this.javaAgentDetector = new InputArgumentsJavaAgentDetector();
        this.archive = archive;
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader classloader = null;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (classloader == null) {
            classloader = ExecutableArchiveLauncher.class.getClassLoader();
        }
        return classloader;
    }

    protected final Archive getArchive() {
        return this.archive;
    }

    @Override
    protected String getMainClass() throws Exception {
        return this.archive.getMainClass();
    }

    @Override
    protected List<Archive> getClassPathArchives() throws Exception {
        ArrayList<Archive> archives = new ArrayList<Archive>(this.archive.getNestedArchives(new Archive.EntryFilter(){

            @Override
            public boolean matches(Archive.Entry entry) {
                return ExecutableArchiveLauncher.this.isNestedArchive(entry);
            }
        }));
        this.postProcessClassPathArchives(archives);
        return archives;
    }

    @Override
    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        LinkedHashSet<URL> copy = new LinkedHashSet<URL>(urls.length);
        ClassLoader loader = ExecutableArchiveLauncher.getDefaultClassLoader();
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                if (!this.addDefaultClassloaderUrl(urls, url)) continue;
                copy.add(url);
            }
        }
        Collections.addAll(copy, urls);
        return super.createClassLoader(copy.toArray(new URL[copy.size()]));
    }

    private boolean addDefaultClassloaderUrl(URL[] urls, URL url) {
        String jarUrl = "jar:" + url + "!/";
        for (URL nestedUrl : urls) {
            if (!nestedUrl.equals(url) && !nestedUrl.toString().equals(jarUrl)) continue;
            return false;
        }
        return !this.javaAgentDetector.isJavaAgentJar(url);
    }

    protected abstract boolean isNestedArchive(Archive.Entry var1);

    protected void postProcessClassPathArchives(List<Archive> archives) throws Exception {
    }
}

