/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.run;

import io.jooby.run.JoobyRun;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.PathFilters;

public abstract class JoobyModuleFinder
implements ModuleFinder {
    protected static final String JARS = "jars";
    protected static final String RESOURCES = "resources";
    protected final Set<Path> classes;
    protected final Set<Path> resources;
    protected final Set<Path> jars;
    protected final String main;
    protected final Set<Path> watchDirs;

    public JoobyModuleFinder(String name, Set<Path> classes, Set<Path> resources, Set<Path> jars, Set<Path> watchDirs) {
        this.main = name;
        this.classes = classes;
        this.resources = resources;
        this.jars = new LinkedHashSet<Path>(resources.size() + 1);
        this.jars.add(JoobyModuleFinder.joobyRunHook(this.getClass()));
        this.jars.addAll(jars);
        this.watchDirs = watchDirs;
    }

    public Set<String> dependencies(String name) {
        return Collections.emptySet();
    }

    private static Path joobyRunHook(Class loader) {
        try {
            URL serverRef = loader.getResource("/" + "io.jooby.run.ServerRef".replace(".", "/") + ".class");
            JarURLConnection connection = (JarURLConnection)serverRef.openConnection();
            return Paths.get(connection.getJarFileURL().toURI());
        }
        catch (IOException | URISyntaxException x) {
            throw new IllegalStateException("jooby-run.jar not found", x);
        }
    }

    public static ModuleSpec createModuleSpec(String name, Set<Path> resources, Set<String> dependencies) {
        ModuleSpec.Builder builder = JoobyModuleFinder.newModule(name, resources);
        for (String dependency : dependencies) {
            builder.addDependency((DependencySpec)new ModuleDependencySpecBuilder().setImportFilter(PathFilters.acceptAll()).setExportFilter(PathFilters.getMetaInfServicesFilter()).setName(dependency).setOptional(false).build());
        }
        return builder.create();
    }

    private static ModuleSpec.Builder newModule(String name, Set<Path> resources) {
        try {
            ModuleSpec.Builder builder = ModuleSpec.build((String)name);
            builder.addDependency(DependencySpec.createSystemDependencySpec((Set)PathUtils.getPathSet(null)));
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            builder.addDependency(DependencySpec.OWN_DEPENDENCY);
            for (Path path : resources) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createPathResourceLoader((Path)path)));
                    continue;
                }
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((JarFile)new JarFile(path.toFile()))));
            }
            return builder;
        }
        catch (IOException x) {
            throw (RuntimeException)JoobyRun.sneakyThrow0(x);
        }
    }

    public String toString() {
        return "classes: " + this.classes.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)) + "\nresources: " + this.resources.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)) + "\nwatchDirs: " + this.watchDirs.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)) + "\njars: " + this.jars.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
    }
}

