/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.run;

import io.jooby.run.JoobyRun;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.PathFilters;

final class ModuleSpecHelper {
    private ModuleSpecHelper() {
    }

    public static ModuleSpec create(String name, Set<Path> resources, Set<String> dependencies) {
        ModuleSpec.Builder builder = ModuleSpecHelper.newModule(name, resources);
        for (String dependency : dependencies) {
            builder.addDependency((DependencySpec)new ModuleDependencySpecBuilder().setImportFilter(PathFilters.acceptAll()).setExportFilter(PathFilters.getMetaInfServicesFilter()).setName(dependency).setOptional(false).build());
        }
        return builder.create();
    }

    private static ModuleSpec.Builder newModule(String name, Set<Path> resources) {
        try {
            ModuleSpec.Builder builder = ModuleSpec.build((String)name);
            builder.addDependency(DependencySpec.createSystemDependencySpec((Set)PathUtils.getPathSet(null)));
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            builder.addDependency(DependencySpec.OWN_DEPENDENCY);
            for (Path path : resources) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createPathResourceLoader((Path)path)));
                    continue;
                }
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((JarFile)new JarFile(path.toFile()))));
            }
            return builder;
        }
        catch (IOException x) {
            throw (RuntimeException)JoobyRun.sneakyThrow0(x);
        }
    }
}

