/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.run;

import io.jooby.internal.run.ModuleSpecHelper;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

public class JoobyModuleFinder
implements ModuleFinder {
    private static final String JARS = "jars";
    private static final String RESOURCES = "resources";
    private final Set<Path> classes;
    private final Set<Path> resources;
    private final Set<Path> jars;
    private final String main;
    private final Set<Path> watchDirs;

    public JoobyModuleFinder(String name, Set<Path> classes, Set<Path> resources, Set<Path> jars, Set<Path> watchDirs) {
        this.main = name;
        this.classes = classes;
        this.resources = resources;
        this.jars = new LinkedHashSet<Path>(resources.size() + 1);
        this.jars.add(JoobyModuleFinder.joobyRunHook(this.getClass()));
        this.jars.addAll(jars);
        this.watchDirs = watchDirs;
    }

    static Path joobyRunHook(Class loader) {
        try {
            URL serverRef = loader.getResource("/" + "io.jooby.run.ServerRef".replace(".", "/") + ".class");
            JarURLConnection connection = (JarURLConnection)serverRef.openConnection();
            return Paths.get(connection.getJarFileURL().toURI());
        }
        catch (IOException | URISyntaxException x) {
            throw new IllegalStateException("jooby-run.jar not found", x);
        }
    }

    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) {
        Set<Path> resources = this.resources(name);
        if (resources == null) {
            return null;
        }
        return ModuleSpecHelper.create(name, resources, this.dependencies(name, true));
    }

    public Set<String> dependencies(String name) {
        return this.dependencies(name, false);
    }

    private Set<String> dependencies(String name, boolean addResources) {
        if (this.main.equals(name)) {
            return addResources ? Set.of(RESOURCES, JARS) : Set.of(JARS);
        }
        if (JARS.equals(name)) {
            return addResources ? Set.of(RESOURCES, this.main) : Set.of(this.main);
        }
        return Collections.emptySet();
    }

    private Set<Path> resources(String name) {
        if (this.main.equals(name)) {
            return this.classes;
        }
        if (RESOURCES.equals(name)) {
            return this.resources;
        }
        if (JARS.equals(name)) {
            return this.jars;
        }
        return null;
    }

    public String toString() {
        return "classes: " + this.classes.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)) + "\nresources: " + this.resources.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)) + "\nwatchDirs: " + this.watchDirs.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)) + "\njars: " + this.jars.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
    }
}

