/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.run;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class JoobyRunOptions {
    public static final int DEFAULT_PORT = Integer.parseInt(System.getProperty("server.port", "8080"));
    private String projectName;
    private String mainClass;
    private List<String> restartExtensions = Arrays.asList("conf", "properties", "class");
    private List<String> compileExtensions = Arrays.asList("java", "kt");
    private int port = DEFAULT_PORT;

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<String> getRestartExtensions() {
        return this.restartExtensions;
    }

    public void setRestartExtensions(List<String> restartExtensions) {
        this.restartExtensions = restartExtensions;
    }

    public List<String> getCompileExtensions() {
        return this.compileExtensions;
    }

    public void setCompileExtensions(List<String> compileExtensions) {
        this.compileExtensions = compileExtensions;
    }

    public boolean isCompileExtension(Path path) {
        return this.containsExtension(this.compileExtensions, path);
    }

    public boolean isRestartExtension(Path path) {
        return this.containsExtension(this.restartExtensions, path);
    }

    private boolean containsExtension(List<String> extensions, Path path) {
        String filename = path.getFileName().toString();
        return extensions.stream().anyMatch(ext -> filename.endsWith("." + ext));
    }
}

