/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.run;

import io.jooby.run.FlattenClasspath;
import io.jooby.run.JoobyRunOptions;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoobyRun {
    static final String SERVER_REF = "io.jooby.run.ServerRef";
    static final String SERVER_REF_STOP = "stop";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JoobyRunOptions options;
    private final Set<Path> resources = new LinkedHashSet<Path>();
    private final Set<Path> dependencies = new LinkedHashSet<Path>();
    private DirectoryWatcher watcher;
    private final Map<Path, BiConsumer<String, Path>> watchDirs = new HashMap<Path, BiConsumer<String, Path>>();
    private AppModule module;

    public JoobyRun(JoobyRunOptions options) {
        this.options = options;
    }

    public boolean addResource(Path path, BiConsumer<String, Path> callback) {
        if (this.addResource(path)) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.watchDirs.put(path, callback);
            }
            return true;
        }
        return false;
    }

    public boolean addResource(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            if (path.toString().endsWith(".jar")) {
                this.dependencies.add(path);
            } else {
                this.resources.add(path);
            }
            return true;
        }
        return false;
    }

    public void start() throws Exception {
        this.watcher = this.newWatcher();
        try {
            this.logger.debug("project: {}", (Object)this.toString());
            ModuleFinder[] finders = new ModuleFinder[]{new FlattenClasspath(this.options.getProjectName(), this.resources, this.dependencies)};
            ExtModuleLoader loader = new ExtModuleLoader(finders);
            this.module = new AppModule(this.logger, loader, Thread.currentThread().getContextClassLoader(), this.options);
            this.module.start();
            this.watcher.watch();
        }
        catch (ClosedWatchServiceException expected) {
            this.logger.trace("Watcher.close resulted in exception", (Throwable)expected);
        }
    }

    public void restart() {
        this.module.restart();
    }

    public void shutdown() {
        if (this.module != null) {
            this.module.close();
            this.module = null;
        }
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (Exception x) {
                this.logger.trace("Watcher.close resulted in exception", (Throwable)x);
            }
            finally {
                this.watcher = null;
            }
        }
    }

    private DirectoryWatcher newWatcher() throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>(this.watchDirs.size());
        paths.addAll(this.watchDirs.keySet());
        return DirectoryWatcher.builder().paths(paths).listener(event -> this.onFileChange(event.eventType(), event.path())).build();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.options.getProjectName()).append("\n");
        buff.append("  watch-dirs: ").append("\n");
        this.watchDirs.forEach((path, callback) -> buff.append("    ").append(path.toAbsolutePath()).append("\n"));
        buff.append("  build: ").append("\n");
        this.resources.forEach(it -> buff.append("    ").append(it.toAbsolutePath()).append("\n"));
        buff.append("  dependencies: ").append("\n");
        this.dependencies.forEach(it -> buff.append("    ").append(it.toAbsolutePath()).append("\n"));
        return buff.toString();
    }

    private void onFileChange(DirectoryChangeEvent.EventType kind, Path path) {
        if (kind == DirectoryChangeEvent.EventType.OVERFLOW) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        for (Map.Entry<Path, BiConsumer<String, Path>> entry : this.watchDirs.entrySet()) {
            Path basepath = entry.getKey();
            if (!path.startsWith(basepath)) continue;
            entry.getValue().accept(kind.name(), path);
        }
    }

    private static class AppModule {
        private final Logger logger;
        private final ExtModuleLoader loader;
        private final JoobyRunOptions conf;
        private Module module;
        private ClassLoader contextClassLoader;
        private int counter;

        AppModule(Logger logger, ExtModuleLoader loader, ClassLoader contextClassLoader, JoobyRunOptions conf) {
            this.logger = logger;
            this.loader = loader;
            this.conf = conf;
            this.contextClassLoader = contextClassLoader;
        }

        public void start() {
            try {
                System.setProperty("___jooby_run_hook__", JoobyRun.SERVER_REF);
                System.setProperty("joobyRun.counter", Integer.toString(this.counter++));
                this.module = this.loader.loadModule(this.conf.getProjectName());
                ModuleClassLoader classLoader = this.module.getClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
                this.module.run(this.conf.getMainClass(), new String[]{"server.port=" + this.conf.getPort(), "server.join=false"});
            }
            catch (Exception x) {
                this.logger.error("execution of {} resulted in exception", (Object)this.conf.getMainClass(), (Object)this.withoutReflection(x));
            }
            finally {
                Thread.currentThread().setContextClassLoader(this.contextClassLoader);
            }
        }

        public void restart() {
            this.closeServer();
            this.unloadModule();
            this.start();
        }

        public void close() {
            this.closeServer();
        }

        private Throwable withoutReflection(Throwable cause) {
            while (cause instanceof ReflectiveOperationException) {
                cause = cause.getCause();
            }
            return cause;
        }

        private void unloadModule() {
            try {
                if (this.module != null) {
                    this.loader.unload(this.conf.getProjectName(), this.module);
                }
            }
            catch (Exception x) {
                this.logger.debug("unload module resulted in exception", (Throwable)x);
            }
            finally {
                this.module = null;
            }
        }

        private void closeServer() {
            try {
                Class ref = this.module.getClassLoader().loadClass(JoobyRun.SERVER_REF);
                ref.getDeclaredMethod(JoobyRun.SERVER_REF_STOP, new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception x) {
                this.logger.error("Application shutdown resulted in exception", this.withoutReflection(x));
            }
        }
    }

    private static class ExtModuleLoader
    extends ModuleLoader {
        ExtModuleLoader(ModuleFinder ... finders) {
            super(finders);
        }

        public void unload(String name, Module module) {
            super.unloadModuleLocal(name, module);
        }
    }
}

