/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.internal.openapi.asm.Handle;
import io.jooby.internal.openapi.asm.tree.AbstractInsnNode;
import io.jooby.internal.openapi.asm.tree.InvokeDynamicInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodInsnNode;
import io.jooby.internal.openapi.asm.tree.VarInsnNode;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class InsnSupport {
    public static <N extends AbstractInsnNode> Predicate<N> opcode(int opcode) {
        return n -> n.getOpcode() == opcode;
    }

    public static <N extends AbstractInsnNode> Predicate<N> varInsn(int opcode, int var) {
        return n -> n.getOpcode() == opcode && ((VarInsnNode)n).var == var;
    }

    public static Iterator<AbstractInsnNode> prevIterator(AbstractInsnNode node) {
        return new NodeIterator(node, AbstractInsnNode::getPrevious);
    }

    public static Stream<AbstractInsnNode> prev(AbstractInsnNode node) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(InsnSupport.prevIterator(node), 16), false);
    }

    public static Stream<AbstractInsnNode> prev(AbstractInsnNode from, AbstractInsnNode to) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new NodeIterator(from, to, AbstractInsnNode::getPrevious), 16), false);
    }

    public static Stream<AbstractInsnNode> next(AbstractInsnNode node) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new NodeIterator(node, AbstractInsnNode::getNext), 16), false);
    }

    public static String toString(InvokeDynamicInsnNode node) {
        Handle handle = (Handle)node.bsmArgs[1];
        return handle.getOwner() + "." + node.name + node.desc;
    }

    public static String toString(MethodInsnNode node) {
        return node.owner + "." + node.name + node.desc;
    }

    private static class NodeIterator
    implements Iterator<AbstractInsnNode> {
        private final AbstractInsnNode to;
        private AbstractInsnNode node;
        private Function<AbstractInsnNode, AbstractInsnNode> next;

        public NodeIterator(AbstractInsnNode node, Function<AbstractInsnNode, AbstractInsnNode> next) {
            this(node, null, next);
        }

        public NodeIterator(AbstractInsnNode node, AbstractInsnNode to, Function<AbstractInsnNode, AbstractInsnNode> next) {
            this.node = node;
            this.next = next;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.node != this.to;
        }

        @Override
        public AbstractInsnNode next() {
            AbstractInsnNode it = this.node;
            this.node = this.next.apply(this.node);
            return it;
        }
    }
}

