/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.jooby.StatusCode;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class ResponseExt
extends ApiResponse {
    private static final Set<String> ASYNC_TYPES = Set.of(CompletionStage.class.getName(), CompletableFuture.class.getName(), "io.reactivex.Single", "io.reactivex.Maybe", "io.reactivex.Flowable", "io.reactivex.Observable", "reactor.core.publisher.Flux", "reactor.core.publisher.Mono");
    @JsonIgnore
    private List<String> javaTypes = new ArrayList<String>();
    @JsonIgnore
    private String code;

    public ResponseExt(String code) {
        this.code = code;
    }

    public ResponseExt() {
        this("200");
    }

    @JsonIgnore
    public String getJavaType() {
        return this.javaTypes.isEmpty() ? null : this.javaTypes.get(0);
    }

    public List<String> getJavaTypes() {
        return this.javaTypes;
    }

    public void setJavaTypes(List<String> javaTypes) {
        this.javaTypes = new ArrayList<String>();
        if (javaTypes != null) {
            for (String javaType : javaTypes) {
                this.javaTypes.add(this.unwrapType(javaType));
            }
        }
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            if ("200".equals(this.code)) {
                return StatusCode.OK.reason();
            }
            try {
                StatusCode statusCode = StatusCode.valueOf((int)Integer.parseInt(this.code));
                String reason = statusCode.reason();
                return reason.equals(this.code) ? null : reason;
            }
            catch (NumberFormatException x) {
                return null;
            }
        }
        return description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String toString() {
        return this.getJavaType();
    }

    private String unwrapType(String javaType) {
        return ASYNC_TYPES.stream().filter(javaType::startsWith).findFirst().map(type -> javaType.equals(type) ? "java.lang.Object" : javaType.substring(type.length() + 1, javaType.length() - 1)).orElse(javaType);
    }
}

