/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.internal.openapi.asm.signature.SignatureReader;
import io.jooby.internal.openapi.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ASMType {
    public static String parse(String signature) {
        return ASMType.parse(signature, type -> true);
    }

    public static String parse(String signature, final Predicate<String> filter) {
        String primitive = ASMType.primitive(signature);
        if (primitive != null) {
            return primitive;
        }
        SignatureReader reader = new SignatureReader(signature);
        final LinkedList stack = new LinkedList();
        SignatureVisitor visitor = new SignatureVisitor(589824){

            @Override
            public void visitClassType(String name) {
                if (filter.test(name)) {
                    if (stack.isEmpty()) {
                        TypeName type = new TypeName();
                        type.name = name;
                        stack.push(type);
                    } else {
                        TypeName type = (TypeName)stack.peek();
                        if (type.name == null) {
                            type.name = name;
                        } else {
                            TypeName arg = new TypeName();
                            arg.name = name;
                            type.arguments.add(arg);
                            stack.push(arg);
                        }
                    }
                }
            }

            @Override
            public void visitEnd() {
                if (stack.size() > 1) {
                    stack.pop();
                }
            }

            @Override
            public void visitBaseType(char descriptor) {
                this.visitClassType(String.valueOf(descriptor));
                TypeName type = (TypeName)stack.peek();
                type.prefix = "[";
                type.suffix = null;
            }

            @Override
            public SignatureVisitor visitArrayType() {
                TypeName type = new TypeName();
                type.prefix = "[L";
                type.suffix = ";";
                stack.push(type);
                return this;
            }
        };
        reader.accept(visitor);
        TypeName type = (TypeName)stack.pop();
        return type.toString();
    }

    private static String primitive(String value) {
        switch (value) {
            case "Z": {
                return "boolean";
            }
            case "C": {
                return "char";
            }
            case "B": {
                return "byte";
            }
            case "S": {
                return "short";
            }
            case "I": {
                return "int";
            }
            case "J": {
                return "long";
            }
            case "F": {
                return "float";
            }
            case "D": {
                return "double";
            }
            case "V": {
                return "void";
            }
        }
        return null;
    }

    private static class TypeName {
        String name;
        String prefix;
        String suffix;
        List<TypeName> arguments = new ArrayList<TypeName>();

        private TypeName() {
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            if (this.prefix != null) {
                buff.append(this.prefix);
            }
            buff.append(this.name.replace("/", "."));
            if (this.arguments.size() > 0) {
                String argstring = this.arguments.stream().map(TypeName::toString).collect(Collectors.joining(",", "<", ">"));
                buff.append(argstring);
            }
            if (this.suffix != null) {
                buff.append(this.suffix);
            }
            return buff.toString();
        }
    }
}

