/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.jooby.Context;
import io.jooby.FileUpload;
import io.jooby.SneakyThrows;
import io.jooby.internal.openapi.ClassSource;
import io.jooby.internal.openapi.ModelConverterExt;
import io.jooby.internal.openapi.SchemaRef;
import io.jooby.internal.openapi.TypeFactory;
import io.jooby.internal.openapi.asm.ClassReader;
import io.jooby.internal.openapi.asm.ClassVisitor;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AbstractInsnNode;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.jooby.internal.openapi.asm.util.ASMifier;
import io.jooby.internal.openapi.asm.util.TraceClassVisitor;
import io.jooby.internal.openapi.asm.util.TraceMethodVisitor;
import io.jooby.openapi.DebugOption;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ParserContext {
    private String mainClass;
    private final ModelConverters converters;
    private final Type router;
    private final Map<Type, ClassNode> nodes;
    private final ClassSource source;
    private final Set<Object> instructions = new HashSet<Object>();
    private final Set<DebugOption> debug;
    private final ConcurrentMap<String, SchemaRef> schemas = new ConcurrentHashMap<String, SchemaRef>();

    public ParserContext(ClassSource source, Type router, Set<DebugOption> debug) {
        this(source, new HashMap<Type, ClassNode>(), router, debug);
    }

    private ParserContext(ClassSource source, Map<Type, ClassNode> nodes, Type router, Set<DebugOption> debug) {
        this.router = router;
        this.source = source;
        this.debug = Optional.ofNullable(debug).orElse(Collections.emptySet());
        this.nodes = nodes;
        List<ObjectMapper> mappers = Arrays.asList(Json.mapper(), Yaml.mapper());
        this.jacksonModules(source.getClassLoader(), mappers);
        this.converters = ModelConverters.getInstance();
        mappers.stream().map(ModelConverterExt::new).forEach(arg_0 -> ((ModelConverters)this.converters).addConverter(arg_0));
    }

    private void jacksonModules(ClassLoader classLoader, List<ObjectMapper> mappers) {
        ArrayList<Object> modules = new ArrayList<Object>(2);
        try {
            Module module2 = (Module)classLoader.loadClass("com.fasterxml.jackson.module.kotlin.KotlinModule").newInstance();
            modules.add(module2);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        modules.add(new Jdk8Module());
        modules.forEach(module -> mappers.forEach(mapper -> mapper.registerModule(module)));
        mappers.stream().forEach(mapper -> mapper.setTypeFactory(mapper.getTypeFactory().withClassLoader(classLoader)));
    }

    public Collection<Schema> schemas() {
        return this.schemas.values().stream().map(ref -> ref.schema).collect(Collectors.toList());
    }

    public Schema schema(Class type) {
        if (this.isVoid(type.getName())) {
            return null;
        }
        if (type == String.class) {
            return new StringSchema();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new IntegerSchema().minimum(BigDecimal.valueOf(-128L)).maximum(BigDecimal.valueOf(127L));
        }
        if (type == Character.class || type == Character.TYPE) {
            return new StringSchema().minLength(Integer.valueOf(0)).maxLength(Integer.valueOf(1));
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return new BooleanSchema();
        }
        if (type == Short.class || type == Short.TYPE) {
            return new IntegerSchema().minimum(BigDecimal.valueOf(-32768L)).maximum(BigDecimal.valueOf(32767L));
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerSchema();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new IntegerSchema().format("int64");
        }
        if (type == Float.class || type == Float.TYPE) {
            return new NumberSchema().format("float");
        }
        if (type == Double.class || type == Double.TYPE) {
            return new NumberSchema().format("double");
        }
        if (Set.class.isAssignableFrom(type)) {
            return new ArraySchema().uniqueItems(Boolean.valueOf(true));
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new ArraySchema();
        }
        if (File.class.isAssignableFrom(type) || Path.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type)) {
            return new BinarySchema();
        }
        if (FileUpload.class == type) {
            return new FileSchema();
        }
        if (Reader.class.isAssignableFrom(type)) {
            return new StringSchema();
        }
        if (byte[].class == type || ByteBuffer.class == type) {
            return new ByteArraySchema();
        }
        if (UUID.class == type) {
            return new UUIDSchema();
        }
        if (BigInteger.class == type) {
            return new IntegerSchema().format(null);
        }
        if (BigDecimal.class == type) {
            return new NumberSchema().format(null);
        }
        if (type.isArray()) {
            return new ArraySchema();
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapSchema();
        }
        if (type == Object.class || type == Void.TYPE || type == Void.class) {
            return new ObjectSchema();
        }
        if (type.isEnum()) {
            StringSchema schema = new StringSchema();
            EnumSet.allOf(type).forEach(e -> schema.addEnumItem(((Enum)e).name()));
            return schema;
        }
        return this.schemas.computeIfAbsent(type.getName(), k -> {
            ResolvedSchema resolvedSchema = this.converters.readAllAsResolvedSchema((java.lang.reflect.Type)type);
            if (resolvedSchema.schema == null) {
                throw new IllegalArgumentException("Unsupported type: " + type);
            }
            return new SchemaRef(resolvedSchema.schema, RefUtils.constructRef((String)resolvedSchema.schema.getName()));
        }).toSchema();
    }

    public Optional<SchemaRef> schemaRef(String type) {
        return Optional.ofNullable(this.schemas.get(type));
    }

    public Schema schema(String type) {
        if (this.isVoid(type)) {
            return null;
        }
        SchemaRef schema = (SchemaRef)this.schemas.get(type);
        if (schema != null) {
            return schema.toSchema();
        }
        String json = "{\"type\":\"" + type + "\"}";
        try {
            TypeLiteral literal = (TypeLiteral)Json.mapper().readValue(json, TypeLiteral.class);
            if (literal.type.isCollectionLikeType() || literal.type.isArrayType()) {
                ArraySchema array = new ArraySchema();
                Class itemType = literal.type.getContentType().getRawClass();
                Optional.ofNullable(this.schema(itemType)).ifPresent(arg_0 -> ((ArraySchema)array).setItems(arg_0));
                return array;
            }
            if (literal.type.getRawClass() == Optional.class) {
                List typeParameters = literal.type.getBindings().getTypeParameters();
                Class itemType = ((JavaType)typeParameters.get(0)).getRawClass();
                return this.schema(itemType);
            }
            return this.schema(literal.type.getRawClass());
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private boolean isVoid(String type) {
        return Context.class.getName().equals(type) || Void.TYPE.getName().equals(type) || Void.class.getName().equals(type);
    }

    public ClassNode classNode(Type type) {
        return this.nodes.computeIfAbsent(type, this::newClassNode);
    }

    public ClassNode classNodeOrNull(Type type) {
        try {
            return this.nodes.computeIfAbsent(type, this::newClassNode);
        }
        catch (Exception x) {
            return null;
        }
    }

    private ClassNode newClassNode(Type type) {
        ClassReader reader = new ClassReader(this.source.byteCode(type.getClassName()));
        if (this.debug.contains((Object)DebugOption.ALL)) {
            this.debug(reader);
        }
        ClassNode node = this.createClassVisitor(ClassNode::new);
        reader.accept(node, 0);
        return node;
    }

    private void debug(ClassReader reader) {
        ASMifier printer = new ASMifier();
        PrintWriter output = new PrintWriter(System.out);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printer, output);
        reader.accept(traceClassVisitor, 0);
    }

    public void debugHandler(MethodNode node) {
        if (this.debug.contains((Object)DebugOption.HANDLER)) {
            this.debug(node);
        }
    }

    private void debug(MethodNode node) {
        System.out.println(Type.getReturnType(node.desc).getClassName() + " " + node.name + " {");
        ASMifier printer = new ASMifier();
        TraceMethodVisitor traceClassVisitor = new TraceMethodVisitor(null, printer);
        node.accept(traceClassVisitor);
        PrintWriter writer = new PrintWriter(System.out);
        printer.print(writer);
        writer.flush();
        System.out.println("}");
    }

    public void debugHandlerLink(MethodNode node) {
        if (this.debug.contains((Object)DebugOption.HANDLER_LINK)) {
            this.debug(node);
        }
    }

    public Type getRouter() {
        return this.router;
    }

    public <T extends ClassVisitor> T createClassVisitor(Function<Integer, T> factory) {
        return (T)((ClassVisitor)factory.apply(458752));
    }

    public boolean isRouter(Type type) {
        return Stream.of(this.router, TypeFactory.JOOBY, TypeFactory.KOOBY, TypeFactory.ROUTER, TypeFactory.COROUTINE_ROUTER).anyMatch(it -> it.equals(type));
    }

    public boolean process(AbstractInsnNode instruction) {
        return this.instructions.add(instruction);
    }

    public ParserContext newContext(Type router) {
        ParserContext ctx = new ParserContext(this.source, this.nodes, router, this.debug);
        return ctx;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public static class TypeLiteral {
        public JavaType type;
    }
}

