/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.internal.openapi.AsmUtils;
import io.jooby.internal.openapi.OperationExt;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.RequestBodyExt;
import io.jooby.internal.openapi.ResponseExt;
import io.jooby.internal.openapi.StatusCodeParser;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AnnotationNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class OpenApiParser {
    public static void parse(ParserContext ctx, MethodNode method, OperationExt operation) {
        AsmUtils.findAnnotationByType(method.visibleAnnotations, Collections.singletonList(Operation.class.getName())).stream().findFirst().ifPresent(a -> OpenApiParser.swaggerOperation(ctx, operation, AsmUtils.toMap(a)));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, Collections.singletonList(ApiResponses.class.getName())).stream().flatMap(a -> AsmUtils.toMap(a).getOrDefault("value", Collections.emptyList()).stream()).forEach(a -> OpenApiParser.operationResponse(ctx, operation, AsmUtils.toMap(a)));
        AsmUtils.findAnnotationByType(method.visibleAnnotations, Collections.singletonList(ApiResponse.class.getName())).stream().findFirst().ifPresent(a -> OpenApiParser.operationResponse(ctx, operation, AsmUtils.toMap(a)));
        OpenApiParser.checkDefaultResponse(operation);
    }

    private static void checkDefaultResponse(OperationExt operation) {
        if (!operation.getResponseCodes().contains("200") && operation.getResponses().keySet().stream().filter(StatusCodeParser::isSuccessCode).count() > 1L) {
            operation.getResponses().remove((Object)"200");
        }
    }

    private static void swaggerOperation(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        AsmUtils.stringValue(annotation, "operationId", arg_0 -> ((OperationExt)operation).setOperationId(arg_0));
        AsmUtils.stringValue(annotation, "method", operation::setMethod);
        AsmUtils.boolValue(annotation, "deprecated", arg_0 -> ((OperationExt)operation).setDeprecated(arg_0));
        AsmUtils.boolValue(annotation, "hidden", operation::setHidden);
        AsmUtils.stringValue(annotation, "summary", arg_0 -> ((OperationExt)operation).setSummary(arg_0));
        AsmUtils.stringValue(annotation, "description", arg_0 -> ((OperationExt)operation).setDescription(arg_0));
        List<String> tags = annotation.getOrDefault("tags", Collections.emptyList());
        tags.forEach(arg_0 -> ((OperationExt)operation).addTagsItem(arg_0));
        OpenApiParser.parameters(ctx, operation, annotation.getOrDefault("parameters", Collections.emptyList()));
        OpenApiParser.requestBody(ctx, operation, AsmUtils.toMap((AnnotationNode)annotation.get("requestBody")));
        OpenApiParser.responses(ctx, operation, annotation);
    }

    private static void requestBody(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        if (annotation.size() > 0) {
            RequestBodyExt requestBody = operation.getRequestBody();
            if (requestBody == null) {
                requestBody = new RequestBodyExt();
                operation.setRequestBody(requestBody);
            }
            AsmUtils.stringValue(annotation, "description", arg_0 -> ((RequestBodyExt)requestBody).setDescription(arg_0));
            AsmUtils.boolValue(annotation, "required", arg_0 -> ((RequestBodyExt)requestBody).setRequired(arg_0));
            String defaultMediaType = operation.getConsumes().stream().findFirst().orElse("application/json");
            OpenApiParser.content(ctx, defaultMediaType, annotation).ifPresent(arg_0 -> ((RequestBodyExt)requestBody).setContent(arg_0));
        }
    }

    @Operation(parameters={@Parameter(name="p", description="des", in=ParameterIn.COOKIE, required=false, deprecated=true, allowEmptyValue=true, allowReserved=false, hidden=false, explode=Explode.TRUE, ref="Pet")})
    private static void parameters(ParserContext ctx, OperationExt operation, List<AnnotationNode> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            io.swagger.v3.oas.models.parameters.Parameter parameter;
            Map<String, Object> parameterMap = AsmUtils.toMap(parameters.get(i));
            String name = (String)parameterMap.get("name");
            if (name != null) {
                int index = i;
                parameter = operation.getParameters().stream().filter(it -> it.getName().equals(name)).findFirst().orElseGet(() -> operation.getParameter(index));
            } else {
                parameter = operation.getParameter(i);
            }
            if (parameter == null) {
                throw new IllegalArgumentException("Parameter not found: " + name + " at  position: " + i + " for annotation: " + parameterMap);
            }
            Optional.ofNullable(name).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setName(arg_0));
            AsmUtils.stringValue(parameterMap, "description", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setDescription(arg_0));
            AsmUtils.enumValue(parameterMap, "in", in -> parameter.setIn(in.toLowerCase()));
            AsmUtils.boolValue(parameterMap, "required", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setRequired(arg_0));
            AsmUtils.boolValue(parameterMap, "deprecated", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setDeprecated(arg_0));
            AsmUtils.boolValue(parameterMap, "allowEmptyValue", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setAllowEmptyValue(arg_0));
            AsmUtils.boolValue(parameterMap, "allowReserved", arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setAllowReserved(arg_0));
            AsmUtils.enumValue(parameterMap, "explode", value -> parameter.setExample((Object)Boolean.valueOf(value)));
            AsmUtils.stringValue(parameterMap, "ref", ref -> parameter.set$ref(RefUtils.constructRef((String)ref)));
            OpenApiParser.arrayOrSchema(ctx, parameterMap).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setSchema(arg_0));
        }
    }

    private static void responses(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        List responses = annotation.getOrDefault("responses", Collections.emptyList());
        responses.stream().map(it -> AsmUtils.toMap(it)).forEach(it -> OpenApiParser.operationResponse(ctx, operation, it));
    }

    @Operation(responses={@ApiResponse})
    private static void operationResponse(ParserContext ctx, OperationExt operation, Map<String, Object> annotation) {
        String code = ((String)annotation.getOrDefault("responseCode", "200")).replace("default", "200");
        ResponseExt response = operation.addResponse(code);
        LinkedHashMap headers = new LinkedHashMap();
        annotation.getOrDefault("headers", Collections.emptyList()).stream().map(a -> AsmUtils.toMap(a)).forEach(a -> {
            String name = (String)a.get("name");
            Header h = new Header();
            AsmUtils.stringValue(a, "description", arg_0 -> ((Header)h).setDescription(arg_0));
            io.swagger.v3.oas.models.media.Schema schema = OpenApiParser.toSchema(ctx, AsmUtils.toMap((AnnotationNode)a.get("schema"))).orElseGet(StringSchema::new);
            h.setSchema(schema);
            headers.put(name, h);
        });
        if (headers.size() > 0) {
            response.setHeaders(headers);
        }
        String description = (String)annotation.getOrDefault("description", "");
        String defaultMediaType = operation.getProduces().stream().findFirst().orElse("application/json");
        OpenApiParser.content(ctx, defaultMediaType, annotation).ifPresent(arg_0 -> ((ResponseExt)response).setContent(arg_0));
        if (description.trim().length() > 0) {
            response.setDescription(description.trim());
        }
    }

    @Operation(responses={@ApiResponse(content={@io.swagger.v3.oas.annotations.media.Content})})
    private static Optional<Content> content(ParserContext ctx, String defaultMediaType, Map<String, Object> annotation) {
        Content content = new Content();
        annotation.getOrDefault("content", Collections.emptyList()).stream().map(n -> AsmUtils.toMap(n)).forEach(a -> OpenApiParser.mediaType(ctx, content, defaultMediaType, a));
        return content.isEmpty() ? Optional.empty() : Optional.of(content);
    }

    @ApiResponse(content={@io.swagger.v3.oas.annotations.media.Content(mediaType="media/type", array=@ArraySchema(schema=@Schema(implementation=String.class)))})
    private static void mediaType(ParserContext ctx, Content content, String defaultMediaType, Map<String, Object> contentMap) {
        if (contentMap == null || contentMap.isEmpty()) {
            return;
        }
        Optional<io.swagger.v3.oas.models.media.Schema> schema = OpenApiParser.arrayOrSchema(ctx, contentMap);
        String mediaType = (String)contentMap.getOrDefault("mediaType", defaultMediaType);
        MediaType mediaTypeObject = new MediaType();
        schema.ifPresent(arg_0 -> ((MediaType)mediaTypeObject).setSchema(arg_0));
        content.addMediaType(mediaType, mediaTypeObject);
    }

    private static Optional<io.swagger.v3.oas.models.media.Schema> arrayOrSchema(ParserContext ctx, Map<String, Object> annotation) {
        AnnotationNode e = (AnnotationNode)annotation.get("array");
        if (e != null) {
            return OpenApiParser.toArraySchema(ctx, AsmUtils.toMap(e));
        }
        return OpenApiParser.toSchema(ctx, AsmUtils.toMap((AnnotationNode)annotation.get("schema")));
    }

    private static Optional<io.swagger.v3.oas.models.media.Schema> toArraySchema(ParserContext ctx, Map<String, Object> annotation) {
        io.swagger.v3.oas.models.media.ArraySchema arraySchema = new io.swagger.v3.oas.models.media.ArraySchema();
        AsmUtils.boolValue(annotation, "uniqueItems", arg_0 -> ((io.swagger.v3.oas.models.media.ArraySchema)arraySchema).setUniqueItems(arg_0));
        AsmUtils.intValue(annotation, "maxItems", arg_0 -> ((io.swagger.v3.oas.models.media.ArraySchema)arraySchema).setMaxItems(arg_0));
        AsmUtils.intValue(annotation, "minItems", arg_0 -> ((io.swagger.v3.oas.models.media.ArraySchema)arraySchema).setMinItems(arg_0));
        if (annotation.containsKey("arraySchema")) {
            OpenApiParser.toArraySchema(ctx, AsmUtils.toMap((AnnotationNode)annotation.get("arraySchema"))).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.media.ArraySchema)arraySchema).setItems(arg_0));
        } else {
            OpenApiParser.toSchema(ctx, AsmUtils.toMap((AnnotationNode)annotation.get("schema"))).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.media.ArraySchema)arraySchema).setItems(arg_0));
        }
        return Optional.of(arraySchema);
    }

    private static Optional<io.swagger.v3.oas.models.media.Schema> toSchema(ParserContext ctx, Map<String, Object> annotation) {
        io.swagger.v3.oas.models.media.Schema schema;
        HashMap schemaMap = new HashMap();
        OpenApiParser.schemaType(ctx, annotation, "implementation", schemaMap::put);
        OpenApiParser.schemaType(ctx, annotation, "not", schemaMap::put);
        OpenApiParser.schemaType(ctx, annotation, "anyOf", schemaMap::put);
        OpenApiParser.schemaType(ctx, annotation, "oneOf", schemaMap::put);
        OpenApiParser.schemaType(ctx, annotation, "allOf", schemaMap::put);
        if (schemaMap.isEmpty()) {
            return Optional.empty();
        }
        List schemas = (List)schemaMap.get("implementation");
        if (schemas.isEmpty()) {
            ComposedSchema composedSchema = new ComposedSchema();
            Optional.ofNullable(schemaMap.get("anyOf")).ifPresent(arg_0 -> ((ComposedSchema)composedSchema).anyOf(arg_0));
            Optional.ofNullable(schemaMap.get("oneOf")).ifPresent(arg_0 -> ((ComposedSchema)composedSchema).oneOf(arg_0));
            Optional.ofNullable(schemaMap.get("allOf")).ifPresent(arg_0 -> ((ComposedSchema)composedSchema).allOf(arg_0));
            schema = composedSchema;
        } else {
            schema = (io.swagger.v3.oas.models.media.Schema)schemas.get(0);
        }
        Optional.ofNullable(schemaMap.get("not")).ifPresent(not -> schema.not((io.swagger.v3.oas.models.media.Schema)not.get(0)));
        return Optional.of(schema);
    }

    private static void schemaType(ParserContext ctx, Map<String, Object> schema, String property, BiConsumer<String, List<io.swagger.v3.oas.models.media.Schema>> consumer) {
        Object value = schema.get(property);
        List<Object> types = value instanceof List ? (List)value : (value instanceof Type ? Collections.singletonList((Type)value) : Collections.emptyList());
        if (types.size() > 0) {
            List schemas = types.stream().map(Type::getClassName).map(ctx::schema).filter(Objects::nonNull).collect(Collectors.toList());
            consumer.accept(property, schemas);
        }
    }
}

