/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.Context;
import io.jooby.internal.openapi.ASMType;
import io.jooby.internal.openapi.InsnSupport;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.TypeFactory;
import io.jooby.internal.openapi.asm.Handle;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AbstractInsnNode;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.InsnNode;
import io.jooby.internal.openapi.asm.tree.IntInsnNode;
import io.jooby.internal.openapi.asm.tree.InvokeDynamicInsnNode;
import io.jooby.internal.openapi.asm.tree.LabelNode;
import io.jooby.internal.openapi.asm.tree.LdcInsnNode;
import io.jooby.internal.openapi.asm.tree.LineNumberNode;
import io.jooby.internal.openapi.asm.tree.LocalVariableNode;
import io.jooby.internal.openapi.asm.tree.MethodInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.jooby.internal.openapi.asm.tree.TypeInsnNode;
import io.jooby.internal.openapi.asm.tree.VarInsnNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReturnTypeParser {
    public static List<String> parse(ParserContext ctx, MethodNode node) {
        boolean notSynthetic;
        Type returnType = Type.getReturnType(node.desc);
        boolean bl = notSynthetic = (node.access & 0x1000) == 0;
        if (notSynthetic && !TypeFactory.OBJECT.equals(returnType) && !TypeFactory.VOID.equals(returnType) && !TypeFactory.JOOBY.equals(returnType)) {
            if (node.signature == null) {
                return Collections.singletonList(ASMType.parse(returnType.getDescriptor()));
            }
            String desc = node.signature;
            int rparen = desc.indexOf(41);
            if (rparen > 0) {
                desc = desc.substring(rparen + 1);
            }
            return Collections.singletonList(ASMType.parse(desc));
        }
        return ReturnTypeParser.parseIgnoreSignature(ctx, node);
    }

    public static List<String> parseIgnoreSignature(ParserContext ctx, MethodNode node) {
        List<String> result = InsnSupport.next(node.instructions.getFirst()).filter(it -> it.getOpcode() == 176 || it.getOpcode() == 172 || it.getOpcode() == 177).map(it -> ReturnTypeParser.handleReturnType(ctx, node, it)).map(Object::toString).distinct().collect(Collectors.toList());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String handleReturnType(ParserContext ctx, MethodNode node, AbstractInsnNode it) {
        Type returnType = Type.getReturnType(node.desc);
        if (it.getOpcode() == 177) {
            return returnType.getClassName();
        }
        if (it.getOpcode() == 172 && it instanceof InsnNode) {
            AbstractInsnNode prev = it.getPrevious();
            if (prev instanceof IntInsnNode) {
                return Integer.class.getName();
            }
            if (prev instanceof InsnNode && (prev.getOpcode() == 3 || prev.getOpcode() == 4)) {
                return Boolean.class.getName();
            }
        }
        Iterator<AbstractInsnNode> iterator = InsnSupport.prevIterator(it.getPrevious());
        while (iterator.hasNext()) {
            VarInsnNode varInsn;
            String varType;
            AbstractInsnNode i = iterator.next();
            if (i instanceof MethodInsnNode && ((MethodInsnNode)i).owner.equals("kotlin/jvm/internal/Intrinsics")) {
                iterator.next();
                iterator.next();
                continue;
            }
            if (i instanceof MethodInsnNode && ((MethodInsnNode)i).owner.equals("kotlin/TypeCastException") || i instanceof LineNumberNode || i instanceof LabelNode) continue;
            String sourcedesc = null;
            if (i instanceof MethodInsnNode) {
                MethodInsnNode minnsn = (MethodInsnNode)i;
                if (minnsn.name.equals("<init>")) {
                    return Type.getObjectType(minnsn.owner).getClassName();
                }
                if (i.getOpcode() != 182) return ReturnTypeParser.fromMethodCall(ctx, minnsn);
                AbstractInsnNode invokeDynamic = InsnSupport.prev(i).filter(InvokeDynamicInsnNode.class::isInstance).findFirst().orElse(null);
                if (invokeDynamic == null) return ReturnTypeParser.fromMethodCall(ctx, minnsn);
                sourcedesc = minnsn.desc;
                i = invokeDynamic;
            }
            if (i instanceof LdcInsnNode) {
                Object cst = ((LdcInsnNode)i).cst;
                if (!(cst instanceof Type)) return cst.getClass().getName();
                return ((Type)cst).getClassName();
            }
            if (i instanceof VarInsnNode && (varType = ReturnTypeParser.localVariable(ctx, node, varInsn = (VarInsnNode)i)) != null) {
                return varType;
            }
            if (i instanceof InvokeDynamicInsnNode) {
                InvokeDynamicInsnNode invokeDynamic = (InvokeDynamicInsnNode)i;
                String handleDescriptor = Stream.of(invokeDynamic.bsmArgs).filter(Handle.class::isInstance).map(Handle.class::cast).findFirst().map(h -> {
                    String desc = Type.getReturnType(h.getDesc()).getDescriptor();
                    return "V".equals(desc) ? "java/lang/Object" : desc;
                }).orElse(null);
                String descriptor = Type.getReturnType(Optional.ofNullable(sourcedesc).orElse(invokeDynamic.desc)).getDescriptor();
                if (handleDescriptor == null || handleDescriptor.equals("java/lang/Object")) return ASMType.parse(descriptor);
                if (descriptor.endsWith(";")) {
                    descriptor = descriptor.substring(0, descriptor.length() - 1);
                }
                descriptor = descriptor + "<" + handleDescriptor + ">;";
                return ASMType.parse(descriptor);
            }
            if (i.getOpcode() == 188 && i instanceof IntInsnNode) {
                switch (((IntInsnNode)i).operand) {
                    case 4: {
                        return boolean[].class.getName();
                    }
                    case 5: {
                        return char[].class.getName();
                    }
                    case 8: {
                        return byte[].class.getName();
                    }
                    case 9: {
                        return short[].class.getName();
                    }
                    case 10: {
                        return int[].class.getName();
                    }
                    case 11: {
                        return long[].class.getName();
                    }
                    case 6: {
                        return float[].class.getName();
                    }
                    case 7: {
                        return double[].class.getName();
                    }
                }
            }
            if (i.getOpcode() == 189) {
                TypeInsnNode typeInsn = (TypeInsnNode)i;
                return ASMType.parse("[L" + typeInsn.desc + ";");
            }
            switch (i.getOpcode()) {
                case 84: {
                    return boolean[].class.getName();
                }
                case 85: {
                    return char[].class.getName();
                }
                case 86: {
                    return short[].class.getName();
                }
                case 79: {
                    return int[].class.getName();
                }
                case 80: {
                    return long[].class.getName();
                }
                case 81: {
                    return float[].class.getName();
                }
                case 82: {
                    return double[].class.getName();
                }
                case 83: {
                    return InsnSupport.prev(i).filter(e -> e.getOpcode() == 189).findFirst().map(e -> {
                        TypeInsnNode typeInsn = (TypeInsnNode)e;
                        return ASMType.parse("[L" + typeInsn.desc + ";");
                    }).orElse(Object.class.getName());
                }
            }
        }
        return returnType.getClassName();
    }

    private static String fromMethodCall(ParserContext ctx, MethodInsnNode node) {
        if (node.owner.equals(TypeFactory.CONTEXT.getInternalName())) {
            Type[] arguments = Type.getArgumentTypes(node.desc);
            if (arguments.length == 1 && arguments[0].getClassName().equals(Class.class.getName())) {
                return InsnSupport.prev(node).filter(LdcInsnNode.class::isInstance).findFirst().map(LdcInsnNode.class::cast).filter(it -> it.cst instanceof Type).map(it -> (Type)it.cst).orElse(TypeFactory.OBJECT).getClassName();
            }
            return Object.class.getName();
        }
        Type returnType = Type.getReturnType(node.desc);
        String methodName = node.name.startsWith("access$invoke$") ? node.name.substring("access$".length()) : node.name;
        List<MethodNode> methodNodes = ReturnTypeParser.classMethods(ctx, node.owner);
        return methodNodes.stream().filter(m -> m.name.equals(methodName) && m.desc.equals(node.desc)).findFirst().map(m -> Optional.ofNullable(m.signature).map(s -> {
            int pos = s.indexOf(41);
            return pos > 0 ? s.substring(pos + 1) : s;
        }).map(ASMType::parse).orElseGet(() -> Type.getReturnType(m.desc).getClassName())).orElse(returnType.getClassName());
    }

    private static List<MethodNode> classMethods(ParserContext ctx, String owner) {
        ClassNode classNode = ctx.classNodeOrNull(Type.getObjectType(owner));
        if (classNode == null) {
            return Collections.emptyList();
        }
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        result.addAll(classNode.methods);
        if (classNode.interfaces != null) {
            for (String anInterface : classNode.interfaces) {
                result.addAll(ReturnTypeParser.classMethods(ctx, anInterface));
            }
        }
        return result;
    }

    private static String localVariable(ParserContext ctx, MethodNode m, VarInsnNode varInsn) {
        List<LocalVariableNode> vars;
        LocalVariableNode var;
        int opcode = varInsn.getOpcode();
        if (opcode >= 21 && opcode <= 54 && (var = (LocalVariableNode)(vars = m.localVariables).stream().filter(v -> v.index == varInsn.var).findFirst().orElse(null)) != null) {
            if (var.signature == null) {
                String type;
                Type kotlinLambda;
                ClassNode classNode;
                LocalVariableNode $this;
                Optional<AbstractInsnNode> kt = InsnSupport.prev(varInsn).filter(ReturnTypeParser.kotlinIntrinsics()).findFirst();
                if (kt.isPresent() && ($this = (LocalVariableNode)vars.stream().filter(v -> v.name.equals("this")).findFirst().orElse(null)) != null && (classNode = ctx.classNodeOrNull(kotlinLambda = Type.getType($this.desc))) != null && classNode.signature != null && !(type = ASMType.parse(classNode.signature, (String internalName) -> !internalName.equals("kotlin/jvm/internal/Lambda") && !internalName.equals("kotlin/jvm/functions/Function1") && !internalName.equals("io/jooby/HandlerContext"))).equals(Object.class.getName()) && !type.equals(Void.TYPE.getName())) {
                    return type;
                }
                String type2 = ASMType.parse(var.desc);
                if (type2.startsWith("java.util.")) {
                    VarInsnNode astore = InsnSupport.prev(varInsn).filter(VarInsnNode.class::isInstance).map(VarInsnNode.class::cast).filter(varIns -> varIns.getOpcode() == 58 && varIns.var == var.index).findFirst().orElse(null);
                    if (astore != null) {
                        String returnType;
                        MethodInsnNode methodCall = InsnSupport.prev(astore).filter(it -> it instanceof MethodInsnNode && !ReturnTypeParser.kotlinIntrinsics().test((AbstractInsnNode)it)).map(MethodInsnNode.class::cast).findFirst().orElse(null);
                        if (methodCall != null && !(returnType = ReturnTypeParser.fromMethodCall(ctx, methodCall)).equals(Object.class.getName()) && !returnType.equals(Void.TYPE.getName())) {
                            type2 = returnType;
                        }
                    }
                }
                if (type2.equals(Context.class.getName())) {
                    VarInsnNode store = InsnSupport.prev(varInsn.getPrevious()).filter(it -> it.getOpcode() >= 54 && it.getOpcode() <= 86).filter(VarInsnNode.class::isInstance).map(VarInsnNode.class::cast).filter(it -> it.var == varInsn.var).findFirst().orElse(null);
                    if (store != null) {
                        type2 = ReturnTypeParser.handleReturnType(ctx, m, store);
                    }
                }
                return type2;
            }
            return ASMType.parse(var.signature);
        }
        return null;
    }

    private static Predicate<AbstractInsnNode> kotlinIntrinsics() {
        return i -> i instanceof MethodInsnNode && ((MethodInsnNode)i).owner.equals("kotlin/jvm/internal/Intrinsics");
    }
}

