/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Jooby;
import io.jooby.internal.netty.Http2Extension;
import io.jooby.internal.netty.Http2Settings;
import io.jooby.internal.netty.HttpChunkContentCompressor;
import io.jooby.internal.netty.NettyDateService;
import io.jooby.internal.netty.NettyHandler;
import io.jooby.internal.netty.NettyRequestDecoder;
import io.jooby.internal.netty.NettyResponseEncoder;
import io.jooby.internal.netty.NettyWebSocketCompressor;
import io.jooby.internal.netty.http2.NettyHttp2Configurer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.ssl.SslContext;
import java.util.function.Supplier;

public class NettyPipeline
extends ChannelInitializer<SocketChannel> {
    private static final String H2_HANDSHAKE = "h2-handshake";
    private final SslContext sslContext;
    private final NettyDateService serverDate;
    private final HttpDataFactory httpDataFactory;
    private final HttpDecoderConfig decoderConfig;
    private final Jooby router;
    private final long maxRequestSize;
    private final int bufferSize;
    private final boolean defaultHeaders;
    private final boolean http2;
    private final boolean expectContinue;
    private final Integer compressionLevel;

    public NettyPipeline(SslContext sslContext, NettyDateService dateService, HttpDataFactory httpDataFactory, HttpDecoderConfig decoderConfig, Jooby router, long maxRequestSize, int bufferSize, boolean defaultHeaders, boolean http2, boolean expectContinue, Integer compressionLevel) {
        this.sslContext = sslContext;
        this.serverDate = dateService;
        this.httpDataFactory = httpDataFactory;
        this.decoderConfig = decoderConfig;
        this.router = router;
        this.maxRequestSize = maxRequestSize;
        this.bufferSize = bufferSize;
        this.defaultHeaders = defaultHeaders;
        this.http2 = http2;
        this.expectContinue = expectContinue;
        this.compressionLevel = compressionLevel;
    }

    private NettyHandler createHandler() {
        return new NettyHandler(this.serverDate, this.router, this.maxRequestSize, this.bufferSize, this.httpDataFactory, this.defaultHeaders, this.http2);
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (this.sslContext != null) {
            p.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        if (this.http2) {
            Http2Settings settings = new Http2Settings(this.maxRequestSize, this.sslContext != null);
            Http2Extension extension = new Http2Extension(settings, this::http11, this::http11Upgrade, this::http2, this::http2c);
            NettyHttp2Configurer configurer = new NettyHttp2Configurer();
            ChannelInboundHandler handshake = configurer.configure(extension);
            p.addLast(H2_HANDSHAKE, (ChannelHandler)handshake);
            this.additionalHandlers(p);
            p.addLast("handler", (ChannelHandler)this.createHandler());
        } else {
            this.http11(p);
        }
    }

    private void additionalHandlers(ChannelPipeline p) {
        if (this.expectContinue) {
            p.addLast("expect-continue", (ChannelHandler)new HttpServerExpectContinueHandler());
        }
        if (this.compressionLevel != null) {
            p.addLast("compressor", (ChannelHandler)new HttpChunkContentCompressor(this.compressionLevel));
            p.addLast("ws-compressor", (ChannelHandler)new NettyWebSocketCompressor(this.compressionLevel));
        }
    }

    private void http2(ChannelPipeline pipeline, Supplier<ChannelOutboundHandler> factory) {
        pipeline.addAfter(H2_HANDSHAKE, "http2", (ChannelHandler)factory.get());
    }

    private void http2c(ChannelPipeline pipeline, Supplier<ChannelOutboundHandler> factory) {
        pipeline.addAfter(H2_HANDSHAKE, "http2", (ChannelHandler)factory.get());
    }

    private void http11Upgrade(ChannelPipeline pipeline, Supplier<HttpServerUpgradeHandler.UpgradeCodec> factory) {
        HttpServerCodec serverCodec = new HttpServerCodec(this.decoderConfig);
        pipeline.addAfter(H2_HANDSHAKE, "codec", (ChannelHandler)serverCodec);
        pipeline.addAfter("codec", "h2upgrade", (ChannelHandler)new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)serverCodec, protocol -> protocol.toString().equals("h2c") ? (HttpServerUpgradeHandler.UpgradeCodec)factory.get() : null, (int)this.maxRequestSize));
    }

    private void http11(ChannelPipeline p) {
        p.addLast("decoder", (ChannelHandler)new NettyRequestDecoder(this.decoderConfig));
        p.addLast("encoder", (ChannelHandler)new NettyResponseEncoder());
        this.additionalHandlers(p);
        p.addLast("handler", (ChannelHandler)this.createHandler());
    }
}

