/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.ByteRange;
import io.jooby.CompletionListeners;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.RouterOption;
import io.jooby.Sender;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.WebSocketConfigurer;
import io.jooby.buffer.DataBuffer;
import io.jooby.internal.netty.AssembledFullHttpResponse;
import io.jooby.internal.netty.AssembledHttpResponse;
import io.jooby.internal.netty.HeadersMultiMap;
import io.jooby.internal.netty.HttpRawPostRequestDecoder;
import io.jooby.internal.netty.NettyBody;
import io.jooby.internal.netty.NettyFileUpload;
import io.jooby.internal.netty.NettyOutputStream;
import io.jooby.internal.netty.NettySender;
import io.jooby.internal.netty.NettyServerSentEmitter;
import io.jooby.internal.netty.NettyWebSocket;
import io.jooby.internal.netty.NettyWriter;
import io.jooby.netty.buffer.NettyDataBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.SSLPeerUnverifiedException;

public class NettyContext
implements DefaultContext,
ChannelFutureListener {
    private static final HttpHeaders NO_TRAILING = EmptyHttpHeaders.INSTANCE;
    private static final String STREAM_ID = "x-http2-stream-id";
    private String streamId;
    HeadersMultiMap setHeaders = new HeadersMultiMap();
    private int bufferSize;
    InterfaceHttpPostRequestDecoder decoder;
    private Router router;
    private Route route;
    ChannelHandlerContext ctx;
    private HttpRequest req;
    private String path;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private boolean responseStarted;
    private QueryString query;
    private Formdata formdata;
    private List<FileUpload> files;
    private ValueNode headers;
    private Map<String, String> pathMap = Collections.EMPTY_MAP;
    private MediaType responseType;
    private Map<String, Object> attributes;
    private long contentLength = -1L;
    private boolean needsFlush;
    private Map<String, String> cookies;
    private Map<String, String> responseCookies;
    private Boolean resetHeadersOnError;
    NettyWebSocket webSocket;
    private String method;
    private CompletionListeners listeners;
    private String remoteAddress;
    private String host;
    private String scheme;
    private int port;
    private boolean filesCreated;

    public NettyContext(ChannelHandlerContext ctx, HttpRequest req, Router router, String path, int bufferSize, boolean http2) {
        this.path = path;
        this.ctx = ctx;
        this.req = req;
        this.router = router;
        this.bufferSize = bufferSize;
        this.method = req.method().name();
        if (http2) {
            this.streamId = req.headers().get(STREAM_ID);
            this.ifStreamId(this.streamId);
        }
    }

    @NonNull
    public Router getRouter() {
        return this.router;
    }

    @NonNull
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    @NonNull
    public String getMethod() {
        return this.method;
    }

    @NonNull
    public Context setMethod(@NonNull String method) {
        this.method = method.toUpperCase();
        return this;
    }

    @NonNull
    public Route getRoute() {
        return this.route;
    }

    @NonNull
    public Context setRoute(@NonNull Route route) {
        this.route = route;
        return this;
    }

    @NonNull
    public String getRequestPath() {
        return this.path;
    }

    @NonNull
    public Context setRequestPath(String path) {
        this.path = path;
        return this;
    }

    @NonNull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @NonNull
    public Context setPathMap(@NonNull Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    public final boolean isInIoThread() {
        return this.ctx.channel().eventLoop().inEventLoop();
    }

    @NonNull
    public Context dispatch(@NonNull Runnable action) {
        return this.dispatch(this.router.getWorker(), action);
    }

    public Context dispatch(Executor executor, Runnable action) {
        executor.execute(action);
        return this;
    }

    @NonNull
    public Context detach(@NonNull Route.Handler next) throws Exception {
        next.apply((Context)this);
        return this;
    }

    @NonNull
    public QueryString query() {
        if (this.query == null) {
            String uri = this.req.uri();
            int q = uri.indexOf(63);
            this.query = QueryString.create((Context)this, q >= 0 ? uri.substring(q + 1) : null);
        }
        return this.query;
    }

    @NonNull
    public Formdata form() {
        if (this.formdata == null) {
            this.formdata = Formdata.create((Context)this);
            this.decodeForm(this.formdata);
        }
        return this.formdata;
    }

    @NonNull
    public Value header(@NonNull String name) {
        return Value.create((Context)this, (String)name, (List)this.req.headers().getAll(name));
    }

    @NonNull
    public String getHost() {
        return this.host == null ? super.getHost() : this.host;
    }

    @NonNull
    public Context setHost(@NonNull String host) {
        this.host = host;
        return this;
    }

    @NonNull
    public String getRemoteAddress() {
        if (this.remoteAddress == null) {
            InetSocketAddress inetAddress = (InetSocketAddress)this.ctx.channel().remoteAddress();
            if (inetAddress != null) {
                String hostAddress = inetAddress.getAddress().getHostAddress();
                int i = hostAddress.lastIndexOf(37);
                this.remoteAddress = i > 0 ? hostAddress.substring(0, i) : hostAddress;
                return this.remoteAddress;
            }
            return "";
        }
        return this.remoteAddress;
    }

    @NonNull
    public Context setRemoteAddress(@NonNull String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @NonNull
    public String getProtocol() {
        if (this.ctx.pipeline().get("http2") == null) {
            return this.req.protocolVersion().text();
        }
        return "HTTP/2.0";
    }

    @NonNull
    public List<Certificate> getClientCertificates() {
        SslHandler sslHandler = (SslHandler)this.ctx.channel().pipeline().get("ssl");
        if (sslHandler != null) {
            try {
                return Arrays.asList(sslHandler.engine().getSession().getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException x) {
                throw SneakyThrows.propagate((Throwable)x);
            }
        }
        return Collections.emptyList();
    }

    @NonNull
    public String getScheme() {
        if (this.scheme == null) {
            this.scheme = this.ctx.pipeline().get("ssl") == null ? "http" : "https";
        }
        return this.scheme;
    }

    @NonNull
    public Context setScheme(@NonNull String scheme) {
        this.scheme = scheme;
        return this;
    }

    public int getPort() {
        return this.port > 0 ? this.port : super.getPort();
    }

    @NonNull
    public Context setPort(int port) {
        this.port = port;
        return this;
    }

    @NonNull
    public ValueNode header() {
        if (this.headers == null) {
            LinkedHashMap<String, List> headerMap = new LinkedHashMap<String, List>();
            HttpHeaders headers = this.req.headers();
            Set names = headers.names();
            for (String name : names) {
                headerMap.put(name, headers.getAll(name));
            }
            this.headers = Value.headers((Context)this, headerMap);
        }
        return this.headers;
    }

    @NonNull
    public Body body() {
        if (this.decoder != null && this.decoder.hasNext()) {
            return new NettyBody((Context)this, (HttpData)this.decoder.next(), HttpUtil.getContentLength((HttpMessage)this.req, (long)-1L));
        }
        return Body.empty((Context)this);
    }

    @NonNull
    public Map<String, String> cookieMap() {
        if (this.cookies == null) {
            Set cookies;
            this.cookies = Collections.emptyMap();
            String cookieString = this.req.headers().get((CharSequence)HttpHeaderNames.COOKIE);
            if (cookieString != null && (cookies = ServerCookieDecoder.STRICT.decode(cookieString)).size() > 0) {
                this.cookies = new LinkedHashMap<String, String>(cookies.size());
                for (io.netty.handler.codec.http.cookie.Cookie it : cookies) {
                    this.cookies.put(it.name(), it.value());
                }
            }
        }
        return this.cookies;
    }

    @NonNull
    public Context onComplete(@NonNull Route.Complete task) {
        if (this.listeners == null) {
            this.listeners = new CompletionListeners();
        }
        this.listeners.addListener(task);
        return this;
    }

    @NonNull
    public Context upgrade(WebSocket.Initializer handler) {
        try {
            long timeout;
            this.responseStarted = true;
            Config conf = this.getRouter().getConfig();
            int maxSize = conf.hasPath("websocket.maxSize") ? conf.getBytes("websocket.maxSize").intValue() : 131072;
            String webSocketURL = this.getProtocol() + "://" + this.req.headers().get((CharSequence)HttpHeaderNames.HOST) + this.path;
            WebSocketDecoderConfig config = WebSocketDecoderConfig.newBuilder().allowExtensions(true).allowMaskMismatch(false).withUTF8Validator(false).maxFramePayloadLength(maxSize).build();
            this.webSocket = new NettyWebSocket(this);
            handler.init(Context.readOnly((Context)this), (WebSocketConfigurer)this.webSocket);
            DefaultFullHttpRequest webSocketRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, this.req.method(), this.req.uri(), Unpooled.EMPTY_BUFFER, this.req.headers(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(webSocketURL, null, config);
            WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)webSocketRequest);
            handshaker.handshake(this.ctx.channel(), (FullHttpRequest)webSocketRequest);
            this.webSocket.fireConnect();
            long l = timeout = conf.hasPath("websocket.idleTimeout") ? conf.getDuration("websocket.idleTimeout", TimeUnit.MILLISECONDS) : TimeUnit.MINUTES.toMillis(5L);
            if (timeout > 0L) {
                IdleStateHandler idle = new IdleStateHandler(timeout, 0L, 0L, TimeUnit.MILLISECONDS);
                this.ctx.pipeline().addBefore("handler", "idle", (ChannelHandler)idle);
            }
        }
        catch (Throwable x) {
            this.sendError(x);
        }
        return this;
    }

    @NonNull
    public Context upgrade(@NonNull ServerSentEmitter.Handler handler) {
        this.responseStarted = true;
        this.ctx.writeAndFlush((Object)new AssembledHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders));
        try {
            handler.handle((ServerSentEmitter)new NettyServerSentEmitter(this));
        }
        catch (Throwable x) {
            this.sendError(x);
        }
        return this;
    }

    @NonNull
    public StatusCode getResponseCode() {
        return StatusCode.valueOf((int)this.status.code());
    }

    @NonNull
    public Context setResponseCode(int statusCode) {
        this.status = HttpResponseStatus.valueOf((int)statusCode);
        return this;
    }

    @NonNull
    public Context setResponseHeader(@NonNull String name, @NonNull String value) {
        this.setHeaders.set(name, value);
        return this;
    }

    @NonNull
    public Context removeResponseHeader(@NonNull String name) {
        this.setHeaders.remove(name);
        return this;
    }

    @NonNull
    public Context removeResponseHeaders() {
        this.setHeaders.clear();
        this.ifStreamId(this.streamId);
        return this;
    }

    @NonNull
    public MediaType getResponseType() {
        return this.responseType == null ? MediaType.text : this.responseType;
    }

    @NonNull
    public Context setDefaultResponseType(@NonNull MediaType contentType) {
        if (this.responseType == null) {
            this.setResponseType(contentType, contentType.getCharset());
        }
        return this;
    }

    public final Context setResponseType(MediaType contentType, Charset charset) {
        this.responseType = contentType;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType.toContentTypeHeader(charset));
        return this;
    }

    @NonNull
    public Context setResponseType(@NonNull String contentType) {
        this.responseType = MediaType.valueOf((String)contentType);
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType);
        return this;
    }

    @Nullable
    public String getResponseHeader(@NonNull String name) {
        return this.setHeaders.get(name);
    }

    @NonNull
    public Context setResponseLength(long length) {
        this.contentLength = length;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Long.toString(length));
        return this;
    }

    public long getResponseLength() {
        if (this.contentLength == -1L) {
            return Long.parseLong(this.setHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "-1"));
        }
        return this.contentLength;
    }

    @NonNull
    public Context setResponseCookie(@NonNull Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new HashMap<String, String>();
        }
        cookie.setPath(cookie.getPath(this.getContextPath()));
        this.responseCookies.put(cookie.getName(), cookie.toCookieString());
        this.setHeaders.remove((CharSequence)HttpHeaderNames.SET_COOKIE);
        for (String cookieString : this.responseCookies.values()) {
            this.setHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)cookieString);
        }
        return this;
    }

    @NonNull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.setResponseType(type, charset);
        return new PrintWriter(new NettyWriter(this.newOutputStream(), charset));
    }

    @NonNull
    public Sender responseSender() {
        this.prepareChunked();
        this.ctx.write((Object)new AssembledHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders));
        return new NettySender(this, this.ctx);
    }

    @NonNull
    public OutputStream responseStream() {
        return this.newOutputStream();
    }

    @NonNull
    public Context send(@NonNull String data) {
        return this.send(Unpooled.copiedBuffer((CharSequence)data, (Charset)StandardCharsets.UTF_8));
    }

    public final Context send(String data, Charset charset) {
        return this.send(Unpooled.copiedBuffer((CharSequence)data, (Charset)charset));
    }

    public final Context send(byte[] data) {
        return this.send(Unpooled.wrappedBuffer((byte[])data));
    }

    @NonNull
    public Context send(byte[] ... data) {
        return this.send(Unpooled.wrappedBuffer((byte[][])data));
    }

    @NonNull
    public Context send(@NonNull ByteBuffer[] data) {
        return this.send(Unpooled.wrappedBuffer((ByteBuffer[])data));
    }

    public final Context send(ByteBuffer data) {
        return this.send(Unpooled.wrappedBuffer((ByteBuffer)data));
    }

    @NonNull
    public Context send(@NonNull DataBuffer data) {
        return this.send(((NettyDataBuffer)data).getNativeBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context send(@NonNull ByteBuf data) {
        try {
            this.responseStarted = true;
            this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(data.readableBytes()));
            AssembledFullHttpResponse response = new AssembledFullHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders, data, NO_TRAILING);
            if (this.ctx.channel().eventLoop().inEventLoop()) {
                this.needsFlush = true;
                this.ctx.write((Object)response, this.promise(this));
            } else {
                this.ctx.writeAndFlush((Object)response, this.promise(this));
            }
            NettyContext nettyContext = this;
            return nettyContext;
        }
        finally {
            this.requestComplete();
        }
    }

    public void flush() {
        if (this.needsFlush) {
            this.needsFlush = false;
            this.ctx.flush();
            this.destroy(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Context send(@NonNull ReadableByteChannel channel) {
        try {
            this.prepareChunked();
            AssembledHttpResponse rsp = new AssembledHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders);
            int bufferSize = this.contentLength > 0L ? (int)this.contentLength : this.bufferSize;
            this.ctx.channel().eventLoop().execute(() -> {
                this.ctx.write((Object)rsp, this.ctx.voidPromise());
                this.ctx.write((Object)new ChunkedNioStream(channel, bufferSize), this.ctx.voidPromise());
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.promise(this));
            });
            NettyContext nettyContext = this;
            return nettyContext;
        }
        finally {
            this.requestComplete();
        }
    }

    @NonNull
    public Context send(@NonNull InputStream in) {
        if (in instanceof FileInputStream) {
            return this.send(((FileInputStream)in).getChannel());
        }
        try {
            long len = this.responseLength();
            ByteRange range = ByteRange.parse((String)this.req.headers().get((CharSequence)HttpHeaderNames.RANGE), (long)len).apply((Context)this);
            this.prepareChunked();
            ChunkedStream chunkedStream = new ChunkedStream(range.apply(in), this.bufferSize);
            AssembledHttpResponse rsp = new AssembledHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders);
            this.responseStarted = true;
            this.ctx.channel().eventLoop().execute(() -> {
                this.ctx.write((Object)rsp, this.ctx.voidPromise());
                this.ctx.write((Object)chunkedStream, this.ctx.voidPromise());
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.promise(this));
            });
            NettyContext nettyContext = this;
            return nettyContext;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        finally {
            this.requestComplete();
        }
    }

    @NonNull
    public Context send(@NonNull FileChannel file) {
        try {
            long len = file.size();
            this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Long.toString(len));
            ByteRange range = ByteRange.parse((String)this.req.headers().get((CharSequence)HttpHeaderNames.RANGE), (long)len).apply((Context)this);
            AssembledHttpResponse rsp = new AssembledHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders);
            this.responseStarted = true;
            if (this.preferChunked()) {
                this.prepareChunked();
                HttpChunkedInput chunkedInput = new HttpChunkedInput((ChunkedInput)new ChunkedNioFile(file, range.getStart(), range.getEnd(), this.bufferSize));
                this.ctx.channel().eventLoop().execute(() -> {
                    this.ctx.write((Object)rsp, this.ctx.voidPromise());
                    this.ctx.writeAndFlush((Object)chunkedInput, this.promise(this));
                });
            } else {
                this.ctx.channel().eventLoop().execute(() -> {
                    this.ctx.write((Object)rsp, this.ctx.voidPromise());
                    this.ctx.write((Object)new DefaultFileRegion(file, range.getStart(), range.getEnd()), this.ctx.voidPromise());
                    this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.promise(this));
                });
            }
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        finally {
            this.requestComplete();
        }
        return this;
    }

    private boolean preferChunked() {
        return this.isSecure() || this.isGzip() || this.ctx.pipeline().channel().getClass().getName().startsWith("IOUring");
    }

    public boolean isResponseStarted() {
        return this.responseStarted;
    }

    public boolean getResetHeadersOnError() {
        return this.resetHeadersOnError == null ? this.getRouter().getRouterOptions().contains(RouterOption.RESET_HEADERS_ON_ERROR) : this.resetHeadersOnError.booleanValue();
    }

    public Context setResetHeadersOnError(boolean value) {
        this.resetHeadersOnError = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Context send(StatusCode statusCode) {
        try {
            this.setResponseCode(statusCode);
            this.responseStarted = true;
            if (!this.setHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)"0");
            }
            AssembledFullHttpResponse rsp = new AssembledFullHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders, Unpooled.EMPTY_BUFFER, NO_TRAILING);
            if (this.ctx.channel().eventLoop().inEventLoop()) {
                this.needsFlush = true;
                this.ctx.write((Object)rsp, this.promise(this));
            } else {
                this.ctx.writeAndFlush((Object)rsp, this.promise(this));
            }
            NettyContext nettyContext = this;
            return nettyContext;
        }
        finally {
            this.requestComplete();
        }
    }

    void requestComplete() {
        this.fireCompleteEvent();
        this.ifSaveSession();
    }

    public void operationComplete(ChannelFuture future) {
        try {
            this.destroy(future.cause());
        }
        finally {
            if (!HttpUtil.isKeepAlive((HttpMessage)this.req)) {
                future.channel().close();
            }
        }
    }

    private void fireCompleteEvent() {
        if (this.listeners != null) {
            this.listeners.run((Context)this);
        }
    }

    private void ifSaveSession() {
        Session session = this.getSession();
        if (session != null) {
            SessionStore store = this.router.getSessionStore();
            store.saveSession((Context)this, session);
        }
    }

    private Session getSession() {
        return this.attributes == null ? null : (Session)this.attributes.get("session");
    }

    private ChannelPromise promise(ChannelFutureListener listener) {
        if (this.pendingTasks()) {
            return this.ctx.newPromise().addListener((GenericFutureListener)listener);
        }
        return this.ctx.voidPromise();
    }

    private boolean pendingTasks() {
        return this.getSession() != null || this.filesCreated || this.decoder != null || this.listeners != null;
    }

    void destroy(Throwable cause) {
        if (cause != null) {
            if (Server.connectionLost((Throwable)cause)) {
                this.router.getLog().debug("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), cause});
            } else {
                this.router.getLog().error("exception found while sending response {} {}", new Object[]{this.getMethod(), this.getRequestPath(), cause});
            }
        }
        if (this.files != null) {
            for (FileUpload file : this.files) {
                try {
                    file.close();
                }
                catch (Exception x) {
                    this.router.getLog().debug("file upload destroy resulted in exception", (Throwable)x);
                }
            }
            this.files = null;
        }
        if (this.decoder != null) {
            try {
                this.decoder.destroy();
            }
            catch (Exception x) {
                this.router.getLog().debug("body decoder destroy resulted in exception", (Throwable)x);
            }
            this.decoder = null;
        }
    }

    private NettyOutputStream newOutputStream() {
        this.prepareChunked();
        return new NettyOutputStream(this, this.ctx, this.bufferSize, new AssembledHttpResponse(this.route.isHttpHead(), HttpVersion.HTTP_1_1, this.status, this.setHeaders));
    }

    private FileUpload register(FileUpload upload) {
        this.filesCreated = true;
        if (this.files == null) {
            this.files = new ArrayList<FileUpload>();
        }
        this.files.add(upload);
        return upload;
    }

    private void decodeForm(Formdata form) {
        if (this.decoder == null || this.decoder instanceof HttpRawPostRequestDecoder) {
            return;
        }
        try {
            while (this.decoder.hasNext()) {
                HttpData next = (HttpData)this.decoder.next();
                if (next.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                    form.put(next.getName(), this.register(new NettyFileUpload(this.router.getTmpdir(), (io.netty.handler.codec.http.multipart.FileUpload)next)));
                    continue;
                }
                form.put(next.getName(), next.getString(StandardCharsets.UTF_8));
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException next) {
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private long responseLength() {
        String len = this.setHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        return len == null ? -1L : Long.parseLong(len);
    }

    private void prepareChunked() {
        this.responseStarted = true;
        ChannelPipeline pipeline = this.ctx.pipeline();
        if (pipeline.get("chunker") == null) {
            String base = Stream.of("compressor", "encoder", "codec", "http2").filter(name -> pipeline.get(name) != null).findFirst().orElseThrow(() -> new IllegalStateException("No available handler for chunk writer"));
            pipeline.addAfter(base, "chunker", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (!this.setHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            this.setHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
        }
    }

    public String toString() {
        return this.getMethod() + " " + this.getRequestPath();
    }

    private void ifStreamId(String streamId) {
        if (streamId != null && streamId.length() > 0) {
            this.setResponseHeader(STREAM_ID, streamId);
        }
    }

    private boolean isGzip() {
        return this.getRouter().getServerOptions().getCompressionLevel() != null;
    }
}

