/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Sender;
import io.jooby.buffer.DataBuffer;
import io.jooby.internal.netty.NettyContext;
import io.jooby.netty.buffer.NettyDataBuffer;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;

public class NettySender
implements Sender {
    private final NettyContext ctx;
    private final ChannelHandlerContext context;

    public NettySender(NettyContext ctx, ChannelHandlerContext context) {
        this.ctx = ctx;
        this.context = context;
    }

    public Sender write(@NonNull byte[] data, @NonNull Sender.Callback callback) {
        this.context.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])data))).addListener((GenericFutureListener)NettySender.newChannelFutureListener(this.ctx, callback));
        return this;
    }

    @NonNull
    public Sender write(@NonNull DataBuffer data, @NonNull Sender.Callback callback) {
        this.context.writeAndFlush((Object)new DefaultHttpContent(((NettyDataBuffer)data).getNativeBuffer())).addListener((GenericFutureListener)NettySender.newChannelFutureListener(this.ctx, callback));
        return this;
    }

    public void close() {
        this.context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)this.ctx);
        this.ctx.requestComplete();
    }

    private static ChannelFutureListener newChannelFutureListener(NettyContext ctx, Sender.Callback callback) {
        return future -> {
            if (future.isSuccess()) {
                callback.onComplete((Context)ctx, null);
            } else {
                Throwable cause = future.cause();
                try {
                    callback.onComplete((Context)ctx, cause);
                }
                finally {
                    ctx.destroy(cause);
                }
            }
        };
    }
}

