/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.internal.netty.AssembledFullHttpResponse;
import io.jooby.internal.netty.AssembledHttpResponse;
import io.jooby.internal.netty.HeadersMultiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.LastHttpContent;

public class NettyResponseEncoder
extends HttpResponseEncoder {
    protected void encodeHeaders(HttpHeaders headers, ByteBuf buf) {
        if (headers instanceof HeadersMultiMap) {
            HeadersMultiMap headersMultiMap = (HeadersMultiMap)headers;
            headersMultiMap.encode(buf);
        } else {
            super.encodeHeaders(headers, buf);
        }
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        if (msg == Unpooled.EMPTY_BUFFER || msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            return true;
        }
        Class<?> msgClass = msg.getClass();
        if (msgClass == AssembledFullHttpResponse.class || msgClass == AssembledHttpResponse.class) {
            return true;
        }
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpRequest);
    }
}

