/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import java.util.function.Consumer;

class Http2OrHttp11Handler
extends ApplicationProtocolNegotiationHandler {
    private final Consumer<ChannelPipeline> http2;
    private final Consumer<ChannelPipeline> http1;

    public Http2OrHttp11Handler(Consumer<ChannelPipeline> http1, Consumer<ChannelPipeline> http2) {
        super("http/1.1");
        this.http2 = http2;
        this.http1 = http1;
    }

    public void configurePipeline(ChannelHandlerContext ctx, String protocol) {
        if ("http/1.1".equals(protocol)) {
            this.http1.accept(ctx.pipeline());
        } else if ("h2".equals(protocol)) {
            this.http2.accept(ctx.pipeline());
        } else {
            throw new IllegalStateException("Unknown protocol: " + protocol);
        }
    }
}

