/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.internal.netty.Http2Extension;
import io.jooby.internal.netty.Http2Settings;
import io.jooby.internal.netty.HttpChunkContentCompressor;
import io.jooby.internal.netty.NettyHandler;
import io.jooby.internal.netty.NettyWebSocketCompressor;
import io.jooby.internal.netty.http2.NettyHttp2Configurer;
import io.jooby.netty.NettyServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import java.util.function.Supplier;

public class NettyPipeline
extends ChannelInitializer<SocketChannel> {
    private static final String H2_HANDSHAKE = "h2-handshake";
    private Integer compressionLevel;
    private int bufferSize;
    private long maxRequestSize;
    private SslContext sslContext;
    private boolean is100ContinueExpected;
    private boolean http2;
    private Supplier<NettyHandler> handlerFactory;

    public NettyPipeline(Supplier<NettyHandler> handlerFactory, SslContext sslContext, Integer compressionLevel, int bufferSize, long maxRequestSize, boolean http2, boolean is100ContinueExpected) {
        this.sslContext = sslContext;
        this.compressionLevel = compressionLevel;
        this.bufferSize = bufferSize;
        this.maxRequestSize = maxRequestSize;
        this.is100ContinueExpected = is100ContinueExpected;
        this.http2 = http2;
        this.handlerFactory = handlerFactory;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new FlushConsolidationHandler()});
        if (this.sslContext != null) {
            p.addLast("ssl", (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        if (this.http2) {
            Http2Settings settings = new Http2Settings(this.maxRequestSize, this.sslContext != null);
            Http2Extension extension = new Http2Extension(settings, this::http11, this::http11Upgrade, this::http2, this::http2c);
            NettyHttp2Configurer configurer = new NettyHttp2Configurer();
            ChannelInboundHandler handshake = configurer.configure(extension);
            p.addLast(H2_HANDSHAKE, (ChannelHandler)handshake);
            this.setupExpectContinue(p);
            this.setupCompression(p);
            p.addLast("handler", (ChannelHandler)this.handlerFactory.get());
        } else {
            this.http11(p);
        }
    }

    private void setupExpectContinue(ChannelPipeline p) {
        if (this.is100ContinueExpected) {
            p.addLast("expect-continue", (ChannelHandler)new HttpServerExpectContinueHandler());
        }
    }

    private void setupCompression(ChannelPipeline p) {
        if (this.compressionLevel != null) {
            p.addLast("compressor", (ChannelHandler)new HttpChunkContentCompressor(this.compressionLevel));
            p.addLast("ws-compressor", (ChannelHandler)new NettyWebSocketCompressor(this.compressionLevel));
        }
    }

    private void http2(ChannelPipeline pipeline, Supplier<ChannelOutboundHandler> factory) {
        pipeline.addAfter(H2_HANDSHAKE, "http2", (ChannelHandler)factory.get());
    }

    private void http2c(ChannelPipeline pipeline, Supplier<ChannelOutboundHandler> factory) {
        pipeline.addAfter(H2_HANDSHAKE, "http2", (ChannelHandler)factory.get());
    }

    private void http11Upgrade(ChannelPipeline pipeline, Supplier<HttpServerUpgradeHandler.UpgradeCodec> factory) {
        HttpServerCodec serverCodec = this.createServerCodec();
        pipeline.addAfter(H2_HANDSHAKE, "codec", (ChannelHandler)serverCodec);
        pipeline.addAfter("codec", "h2upgrade", (ChannelHandler)new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)serverCodec, protocol -> protocol.toString().equals("h2c") ? (HttpServerUpgradeHandler.UpgradeCodec)factory.get() : null, (int)this.maxRequestSize));
    }

    private void http11(ChannelPipeline p) {
        HttpServerCodec codec = this.createServerCodec();
        p.addLast("codec", (ChannelHandler)codec);
        this.setupExpectContinue(p);
        this.setupCompression(p);
        p.addLast("handler", (ChannelHandler)this.handlerFactory.get());
    }

    HttpServerCodec createServerCodec() {
        return new HttpServerCodec(4096, 8192, this.bufferSize, NettyServer.VALIDATE_HEADERS);
    }
}

