/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import io.jooby.WebSocketConfigurer;
import io.jooby.WebSocketMessage;
import io.jooby.internal.netty.NettyContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class NettyWebSocket
implements WebSocketConfigurer,
WebSocket {
    private static final ConcurrentMap<String, List<NettyWebSocket>> all = new ConcurrentHashMap<String, List<NettyWebSocket>>();
    static final AttributeKey<NettyWebSocket> WS = AttributeKey.newInstance((String)NettyWebSocket.class.getName());
    private final NettyContext netty;
    private final boolean dispatch;
    private final String key;
    private ByteBuf buffer;
    private WebSocket.OnConnect connectCallback;
    private WebSocket.OnMessage messageCallback;
    private AtomicReference<WebSocket.OnClose> onCloseCallback = new AtomicReference();
    private WebSocket.OnError onErrorCallback;
    private CountDownLatch ready = new CountDownLatch(1);
    private AtomicBoolean open = new AtomicBoolean(false);

    public NettyWebSocket(NettyContext ctx) {
        this.netty = ctx;
        this.key = ctx.getRoute().getPattern();
        this.dispatch = !ctx.isInIoThread();
        this.netty.ctx.channel().attr(WS).set((Object)this);
    }

    @NonNull
    public WebSocket send(@NonNull String message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage(Unpooled.copiedBuffer((CharSequence)message, (Charset)StandardCharsets.UTF_8), false, callback);
    }

    @NonNull
    public WebSocket send(byte[] bytes, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage(Unpooled.wrappedBuffer((byte[])bytes), false, callback);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull String message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage(Unpooled.copiedBuffer((CharSequence)message, (Charset)StandardCharsets.UTF_8), true, callback);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull byte[] message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendMessage(Unpooled.wrappedBuffer((byte[])message), true, callback);
    }

    public WebSocket render(Object value, @NonNull WebSocket.WriteCallback callback) {
        return this.renderMessage(value, false, callback);
    }

    public WebSocket renderBinary(Object value, @NonNull WebSocket.WriteCallback callback) {
        return this.renderMessage(value, true, callback);
    }

    private WebSocket renderMessage(Object value, boolean binary, WebSocket.WriteCallback callback) {
        try {
            Context.websocket((Context)this.netty, (WebSocket)this, (boolean)binary, (WebSocket.WriteCallback)callback).render(value);
        }
        catch (Throwable x) {
            this.handleError(x);
        }
        return this;
    }

    private WebSocket sendMessage(ByteBuf buffer, boolean binary, WebSocket.WriteCallback callback) {
        if (this.isOpen()) {
            BinaryWebSocketFrame frame = binary ? new BinaryWebSocketFrame(buffer) : new TextWebSocketFrame(buffer);
            this.netty.ctx.channel().writeAndFlush((Object)frame).addListener((GenericFutureListener)new WriteCallbackAdaptor(this, callback));
        } else {
            this.handleError(new IllegalStateException("Attempt to send a message on closed web socket"));
        }
        return this;
    }

    public Context getContext() {
        return Context.readOnly((Context)this.netty);
    }

    @NonNull
    public List<WebSocket> getSessions() {
        List sessions = (List)all.get(this.key);
        if (sessions == null) {
            return Collections.emptyList();
        }
        ArrayList<WebSocket> result = new ArrayList<WebSocket>(sessions);
        result.remove(this);
        return result;
    }

    public boolean isOpen() {
        return this.open.get() && this.netty.ctx.channel().isOpen();
    }

    public void forEach(SneakyThrows.Consumer<WebSocket> callback) {
        for (NettyWebSocket ws : all.getOrDefault(this.key, Collections.emptyList())) {
            try {
                callback.accept((Object)ws);
            }
            catch (Exception cause) {
                this.netty.getRouter().getLog().debug("Broadcast of: {} resulted in exception", (Object)this.netty.getRequestPath(), (Object)cause);
            }
        }
    }

    public WebSocketConfigurer onConnect(WebSocket.OnConnect callback) {
        this.connectCallback = callback;
        return this;
    }

    public WebSocketConfigurer onMessage(WebSocket.OnMessage callback) {
        this.messageCallback = callback;
        return this;
    }

    public WebSocketConfigurer onClose(WebSocket.OnClose callback) {
        this.onCloseCallback.set(callback);
        return this;
    }

    public WebSocketConfigurer onError(WebSocket.OnError callback) {
        this.onErrorCallback = callback;
        return this;
    }

    public WebSocket close(WebSocketCloseStatus closeStatus) {
        this.handleClose(closeStatus);
        return this;
    }

    void handleFrame(WebSocketFrame frame) {
        this.waitForConnect();
        try {
            if (frame instanceof TextWebSocketFrame || frame instanceof BinaryWebSocketFrame || frame instanceof ContinuationWebSocketFrame) {
                this.handleMessage(frame);
            } else if (frame instanceof PingWebSocketFrame) {
                this.netty.ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content())).addListener((GenericFutureListener)new WriteCallbackAdaptor(this, WebSocket.WriteCallback.NOOP));
            } else if (frame instanceof CloseWebSocketFrame) {
                this.handleClose(NettyWebSocket.toWebSocketCloseStatus((CloseWebSocketFrame)frame));
            }
        }
        catch (Throwable x) {
            this.handleError(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(WebSocketFrame frame) {
        try {
            if (this.messageCallback != null) {
                if (frame.isFinalFragment()) {
                    ByteBuf content;
                    if (this.buffer != null) {
                        this.buffer.writeBytes(frame.content());
                        content = this.buffer;
                        this.buffer = null;
                    } else {
                        content = frame.content();
                    }
                    WebSocketMessage message = WebSocketMessage.create((Context)this.getContext(), (byte[])NettyWebSocket.array(content));
                    this.fireCallback(this.webSocketTask(() -> this.messageCallback.onMessage((WebSocket)this, message), false));
                } else {
                    this.buffer = Unpooled.copiedBuffer((ByteBuf)frame.content());
                }
            }
        }
        finally {
            frame.release();
        }
    }

    private void handleClose(WebSocketCloseStatus closeStatus) {
        WebSocket.OnClose callback = this.onCloseCallback.getAndSet(null);
        if (this.isOpen()) {
            this.open.set(false);
            this.netty.ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame(closeStatus.getCode(), closeStatus.getReason())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        try {
            if (callback != null) {
                this.fireCallback(this.webSocketTask(() -> callback.onClose((WebSocket)this, closeStatus), false));
            }
        }
        finally {
            this.netty.ctx.channel().attr(WS).set(null);
            this.removeSession(this);
        }
    }

    private void handleError(Throwable x) {
        if (Server.connectionLost((Throwable)x) || SneakyThrows.isFatal((Throwable)x)) {
            this.handleClose(WebSocketCloseStatus.SERVER_ERROR);
        }
        if (this.onErrorCallback == null) {
            this.netty.getRouter().getLog().error("Websocket resulted in exception: {}", (Object)this.netty.getRequestPath(), (Object)x);
        } else {
            this.onErrorCallback.onError((WebSocket)this, x);
        }
        if (SneakyThrows.isFatal((Throwable)x)) {
            this.netty.ctx.channel().attr(WS).set(null);
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    void fireConnect() {
        this.open.set(true);
        this.addSession(this);
        if (this.connectCallback != null) {
            this.fireCallback(this.webSocketTask(() -> this.connectCallback.onConnect((WebSocket)this), true));
        } else {
            this.ready.countDown();
        }
    }

    private void fireCallback(Runnable task) {
        if (this.dispatch) {
            Router router = this.netty.getRouter();
            router.getWorker().execute(task);
        } else {
            task.run();
        }
    }

    private static byte[] array(ByteBuf buffer) {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.getBytes(0, bytes);
        return bytes;
    }

    private static WebSocketCloseStatus toWebSocketCloseStatus(CloseWebSocketFrame frame) {
        try {
            WebSocketCloseStatus webSocketCloseStatus = WebSocketCloseStatus.valueOf((int)frame.statusCode()).orElseGet(() -> new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
            return webSocketCloseStatus;
        }
        finally {
            frame.release();
        }
    }

    private void addSession(NettyWebSocket ws) {
        all.computeIfAbsent(ws.key, k -> new CopyOnWriteArrayList()).add(ws);
    }

    private void removeSession(NettyWebSocket ws) {
        List sockets = (List)all.get(ws.key);
        if (sockets != null) {
            sockets.remove(ws);
        }
    }

    private Runnable webSocketTask(Runnable runnable, boolean isInit) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable x) {
                this.handleError(x);
            }
            finally {
                if (isInit) {
                    this.ready.countDown();
                }
            }
        };
    }

    private void waitForConnect() {
        try {
            this.ready.await();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    private static class WriteCallbackAdaptor
    implements ChannelFutureListener {
        private NettyWebSocket ws;
        private WebSocket.WriteCallback callback;

        public WriteCallbackAdaptor(NettyWebSocket ws, WebSocket.WriteCallback callback) {
            this.ws = ws;
            this.callback = callback;
        }

        public void operationComplete(ChannelFuture future) {
            Throwable cause = future.cause();
            try {
                if (cause != null) {
                    if (Server.connectionLost((Throwable)cause)) {
                        this.ws.netty.getRouter().getLog().debug("WebSocket {} send method resulted in exception", (Object)this.ws.getContext().getRequestPath(), (Object)cause);
                    } else {
                        this.ws.netty.getRouter().getLog().error("WebSocket {} send method resulted in exception", (Object)this.ws.getContext().getRequestPath(), (Object)cause);
                    }
                }
            }
            finally {
                this.callback.operationComplete((WebSocket)this.ws, cause);
            }
        }
    }
}

