/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.netty;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.SslOptions;
import io.jooby.internal.netty.NettyPipeline;
import io.jooby.internal.netty.NettyTransport;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;

public class NettyServer
extends Server.Base {
    private static final int _50 = 50;
    private static final int _100 = 100;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private EventLoopGroup acceptorloop;
    private EventLoopGroup eventloop;
    private ExecutorService worker;
    private ServerOptions options = new ServerOptions().setServer("netty");

    public NettyServer(@NonNull ExecutorService worker) {
        this.worker = worker;
    }

    public NettyServer() {
    }

    public NettyServer setOptions(@NonNull ServerOptions options) {
        this.options = options;
        return this;
    }

    @NonNull
    public ServerOptions getOptions() {
        return this.options;
    }

    @NonNull
    public String getName() {
        return "netty";
    }

    @NonNull
    public Server start(@NonNull Jooby application) {
        try {
            boolean http2;
            String tmpdir;
            this.applications.add(application);
            this.addShutdownHook();
            if (this.worker == null) {
                this.worker = Executors.newFixedThreadPool(this.options.getWorkerThreads(), (ThreadFactory)new DefaultThreadFactory("worker"));
            }
            this.fireStart(this.applications, this.worker);
            DiskFileUpload.baseDirectory = tmpdir = this.applications.get(0).getTmpdir().toString();
            DiskAttribute.baseDirectory = tmpdir;
            NettyTransport transport = NettyTransport.transport(application.getClassLoader());
            this.acceptorloop = transport.createEventLoop(1, "acceptor", 50);
            this.eventloop = transport.createEventLoop(this.options.getIoThreads(), "eventloop", 100);
            DefaultHttpDataFactory factory = new DefaultHttpDataFactory((long)this.options.getBufferSize());
            boolean bl = http2 = this.options.isHttp2() == Boolean.TRUE;
            if (!this.options.isHttpsOnly()) {
                ServerBootstrap http = this.newBootstrap(transport, this.newPipeline((HttpDataFactory)factory, null, http2));
                http.bind(this.options.getHost(), this.options.getPort()).get();
            }
            if (this.options.isSSLEnabled()) {
                SSLContext javaSslContext = this.options.getSSLContext(application.getEnvironment().getClassLoader());
                SslOptions sslOptions = this.options.getSsl();
                String[] protocol = (String[])sslOptions.getProtocol().stream().toArray(String[]::new);
                SslOptions.ClientAuth clientAuth = sslOptions.getClientAuth();
                SslContext sslContext = this.wrap(javaSslContext, this.toClientAuth(clientAuth), protocol, http2);
                ServerBootstrap https = this.newBootstrap(transport, this.newPipeline((HttpDataFactory)factory, sslContext, http2));
                https.bind(this.options.getHost(), this.options.getSecurePort().intValue()).get();
            } else if (this.options.isHttpsOnly()) {
                throw new IllegalArgumentException("Server configured for httpsOnly, but ssl options not set");
            }
            this.fireReady(this.applications);
        }
        catch (InterruptedException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (Server.isAddressInUse((Throwable)cause)) {
                cause = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)cause);
        }
        return this;
    }

    private ServerBootstrap newBootstrap(NettyTransport transport, NettyPipeline factory) {
        ServerBootstrap http = transport.configure(this.acceptorloop, this.eventloop).childHandler((ChannelHandler)factory).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
        return http;
    }

    private ClientAuth toClientAuth(SslOptions.ClientAuth clientAuth) {
        switch (clientAuth) {
            case REQUIRED: {
                return ClientAuth.REQUIRE;
            }
            case REQUESTED: {
                return ClientAuth.OPTIONAL;
            }
        }
        return ClientAuth.NONE;
    }

    private NettyPipeline newPipeline(HttpDataFactory factory, SslContext sslContext, boolean http2) {
        return new NettyPipeline((ScheduledExecutorService)this.acceptorloop.next(), (Router)this.applications.get(0), factory, sslContext, http2, this.options.getDefaultHeaders(), this.options.getCompressionLevel(), this.options.getBufferSize(), this.options.getMaxRequestSize(), this.options.isExpectContinue() == Boolean.TRUE);
    }

    @NonNull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        this.shutdown(this.acceptorloop);
        this.shutdown(this.eventloop);
        if (this.worker != null) {
            this.worker.shutdown();
            this.worker = null;
        }
        return this;
    }

    private void shutdown(EventLoopGroup loopGroup) {
        try {
            if (loopGroup != null) {
                this.acceptorloop.shutdownGracefully().sync();
            }
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
    }

    private SslContext wrap(SSLContext sslContext, ClientAuth clientAuth, String[] protocol, boolean http2) {
        ApplicationProtocolConfig protocolConfig = http2 ? new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, Arrays.asList("h2", "http/1.1")) : ApplicationProtocolConfig.DISABLED;
        JdkSslContext jdk = new JdkSslContext(sslContext, false, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, protocolConfig, clientAuth, protocol, false);
        return jdk;
    }

    static {
        System.setProperty("io.netty.leakDetection.level", System.getProperty("io.netty.leakDetection.level", "disabled"));
    }
}

