/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Context;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.ServerSentMessage;
import io.jooby.SneakyThrows;
import io.jooby.internal.netty.NettyContext;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerSentEmitter
implements ServerSentEmitter,
GenericFutureListener {
    private Logger log = LoggerFactory.getLogger(ServerSentEmitter.class);
    private final NettyContext netty;
    private String id;
    private AtomicBoolean open = new AtomicBoolean(true);
    private SneakyThrows.Runnable closeTask;

    public NettyServerSentEmitter(NettyContext netty) {
        this.netty = netty;
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public ServerSentEmitter setId(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public Context getContext() {
        return Context.readOnly((Context)this.netty);
    }

    @Nonnull
    public ServerSentEmitter send(ServerSentMessage data) {
        if (this.checkOpen()) {
            this.netty.ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])data.toByteArray((Context)this.netty))).addListener((GenericFutureListener)this);
        } else {
            this.log.warn("server-sent-event closed: {}", (Object)this.id);
        }
        return this;
    }

    public ServerSentEmitter keepAlive(long timeInMillis) {
        if (this.checkOpen()) {
            EventLoop executor = this.netty.ctx.channel().eventLoop().next();
            executor.schedule((Runnable)new ServerSentEmitter.KeepAlive((ServerSentEmitter)this, timeInMillis), timeInMillis, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    public void onClose(SneakyThrows.Runnable task) {
        this.closeTask = task;
    }

    @Nonnull
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            try {
                if (this.closeTask != null) {
                    this.log.debug("running close task on sse {}", (Object)this.id);
                    this.closeTask.run();
                }
            }
            finally {
                this.log.debug("closing sse {}", (Object)this.id);
                this.netty.ctx.close();
            }
        }
    }

    public void operationComplete(Future future) throws Exception {
        if (!future.isSuccess()) {
            if (Server.connectionLost((Throwable)future.cause())) {
                this.close();
            } else {
                this.log.error("server-sent-event resulted in exception: id {} {}", new Object[]{this.id, this.netty.getRequestPath(), future.cause()});
                if (SneakyThrows.isFatal((Throwable)future.cause())) {
                    throw SneakyThrows.propagate((Throwable)future.cause());
                }
            }
        }
    }

    private boolean checkOpen() {
        if (this.isOpen()) {
            if (this.netty.ctx.channel().isOpen()) {
                return true;
            }
            this.close();
            return false;
        }
        return false;
    }
}

