/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.FileUpload;
import io.jooby.SneakyThrows;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class NettyFileUpload
implements FileUpload {
    private final io.netty.handler.codec.http.multipart.FileUpload upload;
    private final Path basedir;
    private final String name;
    private Path path;

    public NettyFileUpload(Path basedir, String name, io.netty.handler.codec.http.multipart.FileUpload upload) {
        this.name = name;
        this.basedir = basedir;
        this.upload = upload;
    }

    public String name() {
        return this.name;
    }

    public byte[] bytes() {
        try {
            if (this.upload.isInMemory()) {
                return this.upload.get();
            }
            return Files.readAllBytes(this.path());
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public InputStream stream() {
        try {
            if (this.upload.isInMemory()) {
                return new ByteBufInputStream(this.upload.content(), true);
            }
            return Files.newInputStream(this.path(), new OpenOption[0]);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public String getFileName() {
        return this.upload.getFilename();
    }

    public String getContentType() {
        return this.upload.getContentType();
    }

    public long getFileSize() {
        return this.upload.length();
    }

    public Path path() {
        try {
            if (this.path == null) {
                if (this.upload.isInMemory()) {
                    this.path = this.basedir.resolve("FUp_" + System.nanoTime() + ".tmp");
                    this.upload.renameTo(this.path.toFile());
                    this.upload.release();
                } else {
                    this.path = this.upload.getFile().toPath();
                }
            }
            return this.path;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public void destroy() {
        try {
            if (this.upload.refCnt() > 0) {
                this.upload.release();
            }
            if (this.path != null) {
                Files.deleteIfExists(this.path);
            }
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

